/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.compaction;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.core.iteratorsImpl.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iteratorsImpl.system.DeletingIterator;
import org.apache.accumulo.core.iteratorsImpl.system.MultiIterator;
import org.apache.accumulo.core.iteratorsImpl.system.TimeSettingIterator;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionReason;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.CompactionInfo;
import org.apache.accumulo.server.compaction.CompactionStats;
import org.apache.accumulo.server.compaction.CountingIterator;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironment;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReportingIterator;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCompactor
implements Callable<CompactionStats> {
    private static final Logger log = LoggerFactory.getLogger(FileCompactor.class);
    private static final AtomicLong nextCompactorID = new AtomicLong(0L);
    private final Map<StoredTabletFile, DataFileValue> filesToCompact;
    private final TabletFile outputFile;
    private final boolean propagateDeletes;
    private final AccumuloConfiguration acuTableConf;
    private final CompactionEnv env;
    private final VolumeManager fs;
    protected final KeyExtent extent;
    private final List<IteratorSetting> iterators;
    private final CryptoService cryptoService;
    private String currentLocalityGroup = "";
    private final long startTime;
    private final AtomicLong entriesRead = new AtomicLong(0L);
    private final AtomicLong entriesWritten = new AtomicLong(0L);
    private final DateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private final long compactorID = nextCompactorID.getAndIncrement();
    protected volatile Thread thread;
    private final ServerContext context;
    protected static final Set<FileCompactor> runningCompactions = Collections.synchronizedSet(new HashSet());

    public long getCompactorID() {
        return this.compactorID;
    }

    private synchronized void setLocalityGroup(String name) {
        this.currentLocalityGroup = name;
    }

    public synchronized String getCurrentLocalityGroup() {
        return this.currentLocalityGroup;
    }

    private void clearStats() {
        this.entriesRead.set(0L);
        this.entriesWritten.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompactionInfo> getRunningCompactions() {
        ArrayList<CompactionInfo> compactions = new ArrayList<CompactionInfo>();
        Set<FileCompactor> set = runningCompactions;
        synchronized (set) {
            for (FileCompactor compactor : runningCompactions) {
                compactions.add(new CompactionInfo(compactor));
            }
        }
        return compactions;
    }

    public FileCompactor(ServerContext context, KeyExtent extent, Map<StoredTabletFile, DataFileValue> files, TabletFile outputFile, boolean propagateDeletes, CompactionEnv env, List<IteratorSetting> iterators, AccumuloConfiguration tableConfiguation, CryptoService cs) {
        this.context = context;
        this.extent = extent;
        this.fs = context.getVolumeManager();
        this.acuTableConf = tableConfiguation;
        this.filesToCompact = files;
        this.outputFile = outputFile;
        this.propagateDeletes = propagateDeletes;
        this.env = env;
        this.iterators = iterators;
        this.cryptoService = cs;
        this.startTime = System.currentTimeMillis();
    }

    public VolumeManager getVolumeManager() {
        return this.fs;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    protected String getOutputFile() {
        return this.outputFile.toString();
    }

    protected Map<String, Set<ByteSequence>> getLocalityGroups(AccumuloConfiguration acuTableConf) throws IOException {
        try {
            return LocalityGroupUtil.getLocalityGroups((AccumuloConfiguration)acuTableConf);
        }
        catch (LocalityGroupUtil.LocalityGroupConfigurationError e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionStats call() throws IOException, CompactionCanceledException {
        FileSKVWriter mfw = null;
        CompactionStats majCStats = new CompactionStats();
        boolean remove = runningCompactions.add(this);
        this.clearStats();
        String oldThreadName = Thread.currentThread().getName();
        String newThreadName = "MajC compacting " + this.extent + " started " + this.dateFormatter.format(new Date()) + " file: " + this.outputFile;
        Thread.currentThread().setName(newThreadName);
        this.thread = Thread.currentThread();
        try {
            FileOperations fileFactory = FileOperations.getInstance();
            FileSystem ns = this.fs.getFileSystemByPath(this.outputFile.getPath());
            mfw = fileFactory.newWriterBuilder().forFile(this.outputFile.getMetaInsert(), ns, ns.getConf(), this.cryptoService).withTableConfiguration(this.acuTableConf).withRateLimiter(this.env.getWriteLimiter()).build();
            Map<String, Set<ByteSequence>> lGroups = this.getLocalityGroups(this.acuTableConf);
            long t1 = System.currentTimeMillis();
            HashSet<ByteSequence> allColumnFamilies = new HashSet<ByteSequence>();
            if (mfw.supportsLocalityGroups()) {
                for (Map.Entry<String, Set<ByteSequence>> entry : lGroups.entrySet()) {
                    this.setLocalityGroup(entry.getKey());
                    this.compactLocalityGroup(entry.getKey(), entry.getValue(), true, mfw, majCStats);
                    allColumnFamilies.addAll((Collection<ByteSequence>)entry.getValue());
                }
            }
            this.setLocalityGroup("");
            this.compactLocalityGroup(null, allColumnFamilies, false, mfw, majCStats);
            long t2 = System.currentTimeMillis();
            FileSKVWriter mfwTmp = mfw;
            mfw = null;
            try {
                mfwTmp.close();
            }
            catch (IOException ex) {
                if (!this.fs.deleteRecursively(this.outputFile.getPath()) && this.fs.exists(this.outputFile.getPath())) {
                    log.error("Unable to delete {}", (Object)this.outputFile);
                }
                throw ex;
            }
            log.trace(String.format("Compaction %s %,d read | %,d written | %,6d entries/sec | %,6.3f secs | %,12d bytes | %9.3f byte/sec", this.extent, majCStats.getEntriesRead(), majCStats.getEntriesWritten(), (int)((double)majCStats.getEntriesRead() / ((double)(t2 - t1) / 1000.0)), (double)(t2 - t1) / 1000.0, mfwTmp.getLength(), (double)mfwTmp.getLength() / ((double)(t2 - t1) / 1000.0)));
            majCStats.setFileSize(mfwTmp.getLength());
            CompactionStats compactionStats = majCStats;
            return compactionStats;
        }
        catch (IOException | RuntimeException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        finally {
            block21: {
                Thread.currentThread().setName(oldThreadName);
                if (remove) {
                    this.thread = null;
                    runningCompactions.remove(this);
                }
                try {
                    if (mfw == null) break block21;
                    try {
                        mfw.close();
                    }
                    finally {
                        if (!this.fs.deleteRecursively(this.outputFile.getPath()) && this.fs.exists(this.outputFile.getPath())) {
                            log.error("Unable to delete {}", (Object)this.outputFile);
                        }
                    }
                }
                catch (IOException | RuntimeException e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private List<SortedKeyValueIterator<Key, Value>> openMapDataFiles(ArrayList<FileSKVIterator> readers) throws IOException {
        ArrayList<SortedKeyValueIterator<Key, Value>> iters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.filesToCompact.size());
        for (TabletFile tabletFile : this.filesToCompact.keySet()) {
            try {
                FileOperations fileFactory = FileOperations.getInstance();
                FileSystem fs = this.fs.getFileSystemByPath(tabletFile.getPath());
                FileSKVIterator reader = fileFactory.newReaderBuilder().forFile(tabletFile.getPathStr(), fs, fs.getConf(), this.cryptoService).withTableConfiguration(this.acuTableConf).withRateLimiter(this.env.getReadLimiter()).build();
                readers.add(reader);
                ProblemReportingIterator iter = new ProblemReportingIterator(this.context, this.extent.tableId(), tabletFile.getPathStr(), false, (SortedKeyValueIterator<Key, Value>)reader);
                if (this.filesToCompact.get(tabletFile).isTimeSet()) {
                    iter = new TimeSettingIterator((SortedKeyValueIterator)iter, this.filesToCompact.get(tabletFile).getTime());
                }
                iters.add((SortedKeyValueIterator<Key, Value>)iter);
            }
            catch (Exception e) {
                ProblemReports.getInstance(this.context).report(new ProblemReport(this.extent.tableId(), ProblemType.FILE_READ, tabletFile.getPathStr(), e));
                log.warn("Some problem opening map file {} {}", new Object[]{tabletFile, e.getMessage(), e});
                for (FileSKVIterator reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        log.warn("Failed to close map file", (Throwable)e2);
                    }
                }
                readers.clear();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException("Failed to open map data files", e);
            }
        }
        return iters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactLocalityGroup(String lgName, Set<ByteSequence> columnFamilies, boolean inclusive, FileSKVWriter mfw, CompactionStats majCStats) throws IOException, CompactionCanceledException {
        block33: {
            ArrayList<FileSKVIterator> readers = new ArrayList<FileSKVIterator>(this.filesToCompact.size());
            Span compactSpan = TraceUtil.startSpan(this.getClass(), (String)"compact");
            try (Scope span = compactSpan.makeCurrent();){
                long entriesCompacted = 0L;
                List<SortedKeyValueIterator<Key, Value>> iters = this.openMapDataFiles(readers);
                if (this.env.getIteratorScope() == IteratorUtil.IteratorScope.minc) {
                    iters.add(this.env.getMinCIterator());
                }
                CountingIterator citr = new CountingIterator((SortedKeyValueIterator<Key, Value>)new MultiIterator(iters, this.extent.toDataRange()), this.entriesRead);
                SortedKeyValueIterator delIter = DeletingIterator.wrap((SortedKeyValueIterator)citr, (boolean)this.propagateDeletes, (DeletingIterator.Behavior)DeletingIterator.getBehavior((AccumuloConfiguration)this.acuTableConf));
                ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator(delIter);
                SystemIteratorEnvironment iterEnv = this.env.createIteratorEnv(this.context, this.acuTableConf, this.getExtent().tableId());
                SortedKeyValueIterator<Key, Value> itr = iterEnv.getTopLevelIterator((SortedKeyValueIterator<Key, Value>)IteratorConfigUtil.convertItersAndLoad((IteratorUtil.IteratorScope)this.env.getIteratorScope(), (SortedKeyValueIterator)cfsi, (AccumuloConfiguration)this.acuTableConf, this.iterators, (IteratorEnvironment)iterEnv));
                itr.seek(this.extent.toDataRange(), columnFamilies, inclusive);
                if (inclusive) {
                    mfw.startNewLocalityGroup(lgName, columnFamilies);
                } else {
                    mfw.startDefaultLocalityGroup();
                }
                Span writeSpan = TraceUtil.startSpan(this.getClass(), (String)"write");
                try (Scope write = writeSpan.makeCurrent();){
                    while (itr.hasTop() && this.env.isCompactionEnabled()) {
                        mfw.append((Key)itr.getTopKey(), (Value)itr.getTopValue());
                        itr.next();
                        if (++entriesCompacted % 1024L != 0L) continue;
                        this.entriesWritten.addAndGet(1024L);
                    }
                    if (!itr.hasTop() || this.env.isCompactionEnabled()) break block33;
                    try {
                        try {
                            mfw.close();
                        }
                        catch (IOException e) {
                            log.error("{}", (Object)e.getMessage(), (Object)e);
                        }
                        this.fs.deleteRecursively(this.outputFile.getPath());
                    }
                    catch (Exception e) {
                        log.warn("Failed to delete Canceled compaction output file {}", (Object)this.outputFile, (Object)e);
                    }
                    throw new CompactionCanceledException();
                }
                finally {
                    CompactionStats lgMajcStats = new CompactionStats(citr.getCount(), entriesCompacted);
                    majCStats.add(lgMajcStats);
                    writeSpan.end();
                }
            }
            catch (Exception e) {
                TraceUtil.setException((Span)compactSpan, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                for (FileSKVIterator reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        log.warn("Failed to close map file", (Throwable)e);
                    }
                }
                compactSpan.end();
            }
        }
    }

    Collection<StoredTabletFile> getFilesToCompact() {
        return this.filesToCompact.keySet();
    }

    boolean hasIMM() {
        return this.env.getIteratorScope() == IteratorUtil.IteratorScope.minc;
    }

    boolean willPropagateDeletes() {
        return this.propagateDeletes;
    }

    long getEntriesRead() {
        return this.entriesRead.get();
    }

    long getEntriesWritten() {
        return this.entriesWritten.get();
    }

    long getStartTime() {
        return this.startTime;
    }

    Iterable<IteratorSetting> getIterators() {
        return this.iterators;
    }

    public TCompactionReason getReason() {
        return this.env.getReason();
    }

    public static interface CompactionEnv {
        public boolean isCompactionEnabled();

        public IteratorUtil.IteratorScope getIteratorScope();

        public RateLimiter getReadLimiter();

        public RateLimiter getWriteLimiter();

        public SystemIteratorEnvironment createIteratorEnv(ServerContext var1, AccumuloConfiguration var2, TableId var3);

        public SortedKeyValueIterator<Key, Value> getMinCIterator();

        public TCompactionReason getReason();
    }

    public static class CompactionCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

