/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;
import org.apache.hadoop.io.WritableComparator;

public class ConditionalMutationSet {
    static void defer(Map<KeyExtent, List<ServerConditionalMutation>> updates, Map<KeyExtent, List<ServerConditionalMutation>> deferredMutations, DeferFilter filter) {
        for (Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry : updates.entrySet()) {
            List<ServerConditionalMutation> scml = entry.getValue();
            ArrayList<ServerConditionalMutation> okMutations = new ArrayList<ServerConditionalMutation>(scml.size());
            ArrayList<ServerConditionalMutation> deferred = new ArrayList<ServerConditionalMutation>();
            filter.defer(scml, okMutations, deferred);
            if (deferred.size() <= 0) continue;
            scml.clear();
            scml.addAll(okMutations);
            List<ServerConditionalMutation> l = deferredMutations.get(entry.getKey());
            if (l == null) {
                l = deferred;
                deferredMutations.put(entry.getKey(), l);
                continue;
            }
            l.addAll(deferred);
        }
    }

    static void deferDuplicatesRows(Map<KeyExtent, List<ServerConditionalMutation>> updates, Map<KeyExtent, List<ServerConditionalMutation>> deferred) {
        ConditionalMutationSet.defer(updates, deferred, new DuplicateFilter());
    }

    static void sortConditionalMutations(Map<KeyExtent, List<ServerConditionalMutation>> updates) {
        for (Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry : updates.entrySet()) {
            Collections.sort(entry.getValue(), (o1, o2) -> WritableComparator.compareBytes((byte[])o1.getRow(), (int)0, (int)o1.getRow().length, (byte[])o2.getRow(), (int)0, (int)o2.getRow().length));
        }
    }

    static class DuplicateFilter
    implements DeferFilter {
        DuplicateFilter() {
        }

        @Override
        public void defer(List<ServerConditionalMutation> scml, List<ServerConditionalMutation> okMutations, List<ServerConditionalMutation> deferred) {
            okMutations.add(scml.get(0));
            for (int i = 1; i < scml.size(); ++i) {
                if (Arrays.equals(scml.get(i - 1).getRow(), scml.get(i).getRow())) {
                    deferred.add(scml.get(i));
                    continue;
                }
                okMutations.add(scml.get(i));
            }
        }
    }

    static interface DeferFilter {
        public void defer(List<ServerConditionalMutation> var1, List<ServerConditionalMutation> var2, List<ServerConditionalMutation> var3);
    }
}

