/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.metrics.MasterMetrics;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationMetrics
extends MasterMetrics {
    private static final Logger log = LoggerFactory.getLogger(ReplicationMetrics.class);
    private final Master master;
    private final ReplicationUtil replicationUtil;
    private final MutableQuantiles replicationQueueTimeQuantiles;
    private final MutableStat replicationQueueTimeStat;
    private final Map<Path, Long> pathModTimes;

    ReplicationMetrics(Master master) {
        super("Replication", "Data-Center Replication Metrics", "MasterReplication");
        this.master = master;
        this.pathModTimes = new HashMap<Path, Long>();
        this.replicationUtil = new ReplicationUtil(master.getContext());
        MetricsRegistry registry = super.getRegistry();
        this.replicationQueueTimeQuantiles = registry.newQuantiles("replicationQueue10m", "Replication queue time quantiles in milliseconds", "ops", "latency", 600);
        this.replicationQueueTimeStat = registry.newStat("replicationQueue", "Replication queue time statistics in milliseconds", "ops", "latency", true);
    }

    protected void prepareMetrics() {
        String PENDING_FILES = "filesPendingReplication";
        if (TableState.ONLINE == Tables.getTableState((ClientContext)this.master.getContext(), (TableId)ReplicationTable.ID) && !this.replicationUtil.getPeers().isEmpty()) {
            this.getRegistry().add("filesPendingReplication", this.getNumFilesPendingReplication());
            this.addReplicationQueueTimeMetrics();
        } else {
            this.getRegistry().add("filesPendingReplication", 0L);
        }
        this.getRegistry().add("numPeers", (long)this.getNumConfiguredPeers());
        this.getRegistry().add("maxReplicationThreads", (long)this.getMaxReplicationThreads());
    }

    protected long getNumFilesPendingReplication() {
        Set allConfiguredTargets = this.replicationUtil.getReplicationTargets();
        Map targetCounts = this.replicationUtil.getPendingReplications();
        long filesPending = 0L;
        for (ReplicationTarget configuredTarget : allConfiguredTargets) {
            Long numFiles = (Long)targetCounts.get(configuredTarget);
            if (numFiles == null) continue;
            filesPending += numFiles.longValue();
        }
        return filesPending;
    }

    protected int getNumConfiguredPeers() {
        return this.replicationUtil.getPeers().size();
    }

    protected int getMaxReplicationThreads() {
        return this.replicationUtil.getMaxReplicationThreads(this.master.getMasterMonitorInfo());
    }

    protected void addReplicationQueueTimeMetrics() {
        Set paths = this.replicationUtil.getPendingReplicationPaths();
        long currentTime = this.getCurrentTime();
        for (Path path : paths) {
            if (this.pathModTimes.containsKey(path)) continue;
            try {
                this.pathModTimes.put(path, this.master.getFileSystem().getFileStatus(path).getModificationTime());
            }
            catch (IOException e) {
                log.trace("Failed to get file status for {}, file system is unavailable or it does not exist", (Object)path);
            }
        }
        HashSet<Path> deletedPaths = new HashSet<Path>(this.pathModTimes.keySet());
        deletedPaths.removeAll(paths);
        if (deletedPaths.isEmpty()) {
            return;
        }
        this.replicationQueueTimeStat.resetMinMax();
        for (Path path : deletedPaths) {
            Long modTime = this.pathModTimes.remove(path);
            if (modTime == null) continue;
            long diff = Math.max(0L, currentTime - modTime);
            this.replicationQueueTimeQuantiles.add(diff);
            this.replicationQueueTimeStat.add(diff);
        }
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

