/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics;

import java.util.Objects;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.metrics.ReplicationMetrics;
import org.apache.accumulo.master.metrics.fate.FateMetrics;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterMetricsFactory {
    private static final Logger log = LoggerFactory.getLogger(MasterMetricsFactory.class);
    private final boolean enableFateMetrics;
    private final long fateMinUpdateInterval;

    public MasterMetricsFactory(AccumuloConfiguration conf) {
        Objects.requireNonNull(conf, "AccumuloConfiguration must not be null");
        this.enableFateMetrics = conf.getBoolean(Property.MASTER_FATE_METRICS_ENABLED);
        this.fateMinUpdateInterval = conf.getTimeInMillis(Property.MASTER_FATE_METRICS_MIN_UPDATE_INTERVAL);
    }

    public int register(Master master) {
        MetricsSystem metricsSystem = master.getMetricsSystem();
        int failureCount = 0;
        try {
            new ReplicationMetrics(master).register(metricsSystem);
            log.info("Registered replication metrics module");
        }
        catch (Exception ex) {
            ++failureCount;
            log.error("Failed to register replication metrics", (Throwable)ex);
        }
        try {
            if (this.enableFateMetrics) {
                new FateMetrics(master.getContext(), this.fateMinUpdateInterval).register(metricsSystem);
                log.info("Registered FATE metrics module");
            }
        }
        catch (Exception ex) {
            ++failureCount;
            log.error("Failed to register fate metrics", (Throwable)ex);
        }
        return failureCount;
    }
}

