/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster;

import java.io.File;
import java.util.Map;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;

public class MiniAccumuloConfig {
    private MiniAccumuloConfigImpl impl;

    MiniAccumuloConfig(MiniAccumuloConfigImpl config) {
        this.impl = config;
    }

    MiniAccumuloConfigImpl getImpl() {
        return this.impl;
    }

    public MiniAccumuloConfig(File dir, String rootPassword) {
        this.impl = new MiniAccumuloConfigImpl(dir, rootPassword);
    }

    public MiniAccumuloConfig setNumTservers(int numTservers) {
        this.impl.setNumTservers(numTservers);
        return this;
    }

    public MiniAccumuloConfig setInstanceName(String instanceName) {
        this.impl.setInstanceName(instanceName);
        return this;
    }

    public MiniAccumuloConfig setSiteConfig(Map<String, String> siteConfig) {
        this.impl.setSiteConfig(siteConfig);
        return this;
    }

    public MiniAccumuloConfig setZooKeeperPort(int zooKeeperPort) {
        this.impl.setZooKeeperPort(zooKeeperPort);
        return this;
    }

    public MiniAccumuloConfig setZooKeeperStartupTime(long zooKeeperStartupTime) {
        this.impl.setZooKeeperStartupTime(zooKeeperStartupTime);
        return this;
    }

    public MiniAccumuloConfig setMemory(ServerType serverType, long memory, MemoryUnit memoryUnit) {
        this.impl.setMemory(serverType, memory, memoryUnit);
        return this;
    }

    public MiniAccumuloConfig setDefaultMemory(long memory, MemoryUnit memoryUnit) {
        this.impl.setDefaultMemory(memory, memoryUnit);
        return this;
    }

    public Map<String, String> getSiteConfig() {
        return this.impl.getConfiguredSiteConfig();
    }

    public String getInstanceName() {
        return this.impl.getInstanceName();
    }

    public int getZooKeeperPort() {
        return this.impl.getConfiguredZooKeeperPort();
    }

    public long getMemory(ServerType serverType) {
        return this.impl.getMemory(serverType);
    }

    public long getDefaultMemory() {
        return this.impl.getDefaultMemory();
    }

    public File getDir() {
        return this.impl.getDir();
    }

    public String getRootPassword() {
        return this.impl.getRootPassword();
    }

    public int getNumTservers() {
        return this.impl.getNumTservers();
    }

    public boolean isJDWPEnabled() {
        return this.impl.isJDWPEnabled();
    }

    public MiniAccumuloConfig setJDWPEnabled(boolean jdwpEnabled) {
        this.impl.setJDWPEnabled(jdwpEnabled);
        return this;
    }

    public String[] getNativeLibPaths() {
        return this.impl.getNativeLibPaths();
    }

    public MiniAccumuloConfig setNativeLibPaths(String ... nativePathItems) {
        this.impl.setNativeLibPaths(nativePathItems);
        return this;
    }

    public MiniAccumuloConfig setClasspath(String ... classpathItems) {
        this.impl.setClasspathItems(classpathItems);
        return this;
    }
}

