/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor;

import java.util.EnumSet;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.monitor.Monitor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedWebServer {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedWebServer.class);
    private final Server server = new Server();
    private final ServerConnector connector;
    private final ServletContextHandler handler;

    public EmbeddedWebServer(Monitor monitor, int port) {
        AccumuloConfiguration conf = monitor.getContext().getConfiguration();
        this.connector = new ServerConnector(this.server, (ConnectionFactory[])EmbeddedWebServer.getConnectionFactories(conf));
        this.connector.setHost(monitor.getHostname());
        this.connector.setPort(port);
        this.handler = new ServletContextHandler(3);
        this.handler.getSessionHandler().getSessionCookieConfig().setHttpOnly(true);
        this.handler.setContextPath("/");
    }

    private static AbstractConnectionFactory[] getConnectionFactories(AccumuloConfiguration conf) {
        String includeProtocols;
        HttpConnectionFactory httpFactory = new HttpConnectionFactory();
        EnumSet<Property> requireForSecure = EnumSet.of(Property.MONITOR_SSL_KEYSTORE, Property.MONITOR_SSL_KEYSTOREPASS, Property.MONITOR_SSL_TRUSTSTORE, Property.MONITOR_SSL_TRUSTSTOREPASS);
        if (requireForSecure.stream().map(p -> conf.get(p)).anyMatch(s -> s == null || s.isEmpty())) {
            LOG.debug("Not configuring Jetty to use TLS");
            return new AbstractConnectionFactory[]{httpFactory};
        }
        LOG.debug("Configuring Jetty to use TLS");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        String keyPass = conf.get(Property.MONITOR_SSL_KEYPASS);
        if (!Property.MONITOR_SSL_KEYPASS.getDefaultValue().equals(keyPass)) {
            sslContextFactory.setKeyManagerPassword(keyPass);
        }
        sslContextFactory.setKeyStorePath(conf.get(Property.MONITOR_SSL_KEYSTORE));
        sslContextFactory.setKeyStorePassword(conf.get(Property.MONITOR_SSL_KEYSTOREPASS));
        sslContextFactory.setKeyStoreType(conf.get(Property.MONITOR_SSL_KEYSTORETYPE));
        sslContextFactory.setTrustStorePath(conf.get(Property.MONITOR_SSL_TRUSTSTORE));
        sslContextFactory.setTrustStorePassword(conf.get(Property.MONITOR_SSL_TRUSTSTOREPASS));
        sslContextFactory.setTrustStoreType(conf.get(Property.MONITOR_SSL_TRUSTSTORETYPE));
        String includedCiphers = conf.get(Property.MONITOR_SSL_INCLUDE_CIPHERS);
        if (!Property.MONITOR_SSL_INCLUDE_CIPHERS.getDefaultValue().equals(includedCiphers)) {
            sslContextFactory.setIncludeCipherSuites(StringUtils.split((String)includedCiphers, (char)','));
        }
        String excludedCiphers = conf.get(Property.MONITOR_SSL_EXCLUDE_CIPHERS);
        if (!Property.MONITOR_SSL_EXCLUDE_CIPHERS.getDefaultValue().equals(excludedCiphers)) {
            sslContextFactory.setExcludeCipherSuites(StringUtils.split((String)excludedCiphers, (char)','));
        }
        if ((includeProtocols = conf.get(Property.MONITOR_SSL_INCLUDE_PROTOCOLS)) != null && !includeProtocols.isEmpty()) {
            sslContextFactory.setIncludeProtocols(StringUtils.split((String)includeProtocols, (char)','));
        }
        SslConnectionFactory sslFactory = new SslConnectionFactory((SslContextFactory)sslContextFactory, httpFactory.getProtocol());
        return new AbstractConnectionFactory[]{sslFactory, httpFactory};
    }

    public void addServlet(ServletHolder restServlet, String where) {
        this.handler.addServlet(restServlet, where);
    }

    public int getPort() {
        return this.connector.getLocalPort();
    }

    public void start() {
        try {
            this.server.addConnector((Connector)this.connector);
            this.server.setHandler((Handler)this.handler);
            this.server.start();
        }
        catch (Exception e) {
            this.stop();
            throw new RuntimeException(e);
        }
    }

    private void stop() {
        try {
            this.server.stop();
            this.server.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }
}

