/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.NumUtil;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.htrace.TraceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDiskUsage {
    private static final Logger log = LoggerFactory.getLogger(TableDiskUsage.class);
    private int nextInternalId = 0;
    private Map<TableId, Integer> internalIds = new HashMap<TableId, Integer>();
    private Map<Integer, TableId> externalIds = new HashMap<Integer, TableId>();
    private Map<String, Integer[]> tableFiles = new HashMap<String, Integer[]>();
    private Map<String, Long> fileSizes = new HashMap<String, Long>();

    void addTable(TableId tableId) {
        if (this.internalIds.containsKey(tableId)) {
            throw new IllegalArgumentException("Already added table " + tableId);
        }
        int iid = this.nextInternalId++;
        this.internalIds.put(tableId, iid);
        this.externalIds.put(iid, tableId);
    }

    void linkFileAndTable(TableId tableId, String file) {
        int internalId = this.internalIds.get(tableId);
        Integer[] tables = this.tableFiles.get(file);
        if (tables == null) {
            tables = new Integer[this.internalIds.size()];
            for (int i = 0; i < tables.length; ++i) {
                tables[i] = 0;
            }
            this.tableFiles.put(file, tables);
        }
        tables[internalId] = 1;
    }

    void addFileSize(String file, long size) {
        this.fileSizes.put(file, size);
    }

    Map<List<TableId>, Long> calculateUsage() {
        HashMap<List<Integer>, Long> usage = new HashMap<List<Integer>, Long>();
        if (log.isTraceEnabled()) {
            log.trace("fileSizes {}", this.fileSizes);
        }
        for (Map.Entry<String, Integer[]> entry : this.tableFiles.entrySet()) {
            if (log.isTraceEnabled()) {
                log.trace("file {} table bitset {}", (Object)entry.getKey(), (Object)Arrays.toString((Object[])entry.getValue()));
            }
            List<Integer> key = Arrays.asList(entry.getValue());
            Long size = this.fileSizes.get(entry.getKey());
            Long tablesUsage = (Long)usage.get(key);
            if (tablesUsage == null) {
                tablesUsage = 0L;
            }
            tablesUsage = tablesUsage + size;
            usage.put(key, tablesUsage);
        }
        HashMap<List<TableId>, Long> externalUsage = new HashMap<List<TableId>, Long>();
        for (Map.Entry entry : usage.entrySet()) {
            ArrayList<TableId> externalKey = new ArrayList<TableId>();
            List key = (List)entry.getKey();
            for (int i = 0; i < key.size(); ++i) {
                if ((Integer)key.get(i) == 0) continue;
                externalKey.add(this.externalIds.get(i));
            }
            externalUsage.put(externalKey, (Long)entry.getValue());
        }
        return externalUsage;
    }

    public static void printDiskUsage(Collection<String> tableNames, VolumeManager fs, AccumuloClient client, boolean humanReadable) throws TableNotFoundException, IOException {
        TableDiskUsage.printDiskUsage(tableNames, fs, client, line -> System.out.println(line), humanReadable);
    }

    public static Map<TreeSet<String>, Long> getDiskUsage(Set<TableId> tableIds, VolumeManager fs, AccumuloClient client) throws IOException {
        TableDiskUsage tdu = new TableDiskUsage();
        for (TableId tableId : tableIds) {
            tdu.addTable(tableId);
        }
        HashSet<TableId> tablesReferenced = new HashSet<TableId>(tableIds);
        HashSet<TableId> emptyTableIds = new HashSet<TableId>();
        HashSet<String> nameSpacesReferenced = new HashSet<String>();
        for (TableId tableId : tableIds) {
            Scanner mdScanner;
            try {
                mdScanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            }
            catch (TableNotFoundException tableNotFoundException) {
                throw new RuntimeException(tableNotFoundException);
            }
            mdScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            mdScanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
            if (!mdScanner.iterator().hasNext()) {
                emptyTableIds.add(tableId);
            }
            Iterator iterator = mdScanner.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String file = ((Key)entry.getKey()).getColumnQualifier().toString();
                String[] parts = file.split("/");
                String uniqueName = parts[parts.length - 1];
                if (file.contains(":") || file.startsWith("../")) {
                    String ref = parts[parts.length - 3];
                    if (!ref.equals(tableId.canonical())) {
                        tablesReferenced.add(TableId.of((String)ref));
                    }
                    if (file.contains(":") && parts.length > 3) {
                        List<String> base = Arrays.asList(Arrays.copyOf(parts, parts.length - 3));
                        nameSpacesReferenced.add(Joiner.on((String)"/").join(base));
                    }
                }
                tdu.linkFileAndTable(tableId, uniqueName);
            }
        }
        for (TableId tableId : tablesReferenced) {
            for (String string : nameSpacesReferenced) {
                FileStatus[] files = fs.globStatus(new Path(string + "/" + tableId + "/*/*"));
                if (files == null) continue;
                for (FileStatus fileStatus : files) {
                    String name = fileStatus.getPath().getName();
                    tdu.addFileSize(name, fileStatus.getLen());
                }
            }
        }
        Map reverseTableIdMap = Tables.getIdToNameMap((ClientContext)((ClientContext)client));
        TreeMap<TreeSet<String>, Long> usage = new TreeMap<TreeSet<String>, Long>((o1, o2) -> {
            int len1 = o1.size();
            int len2 = o2.size();
            int min = Math.min(len1, len2);
            Iterator iter1 = o1.iterator();
            Iterator iter2 = o2.iterator();
            for (int count = 0; count < min; ++count) {
                String s2;
                String s1 = (String)iter1.next();
                int cmp = s1.compareTo(s2 = (String)iter2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            return len1 - len2;
        });
        for (Map.Entry entry : tdu.calculateUsage().entrySet()) {
            TreeSet<String> tableNames = new TreeSet<String>();
            for (TableId tableId : (List)entry.getKey()) {
                tableNames.add((String)reverseTableIdMap.get(tableId));
            }
            usage.put(tableNames, (Long)entry.getValue());
        }
        if (!emptyTableIds.isEmpty()) {
            TreeSet<String> emptyTables = new TreeSet<String>();
            for (TableId tableId : emptyTableIds) {
                emptyTables.add((String)reverseTableIdMap.get(tableId));
            }
            usage.put(emptyTables, 0L);
        }
        return usage;
    }

    public static void printDiskUsage(Collection<String> tableNames, VolumeManager fs, AccumuloClient client, Printer printer, boolean humanReadable) throws TableNotFoundException, IOException {
        HashSet<TableId> tableIds = new HashSet<TableId>();
        for (String tableName : tableNames) {
            TableId tableId = Tables.getTableId((ClientContext)((ClientContext)client), (String)tableName);
            if (tableId == null) {
                throw new TableNotFoundException(null, tableName, "Table " + tableName + " not found");
            }
            tableIds.add(tableId);
        }
        Map<TreeSet<String>, Long> usage = TableDiskUsage.getDiskUsage(tableIds, fs, client);
        String valueFormat = humanReadable ? "%9s" : "%,24d";
        for (Map.Entry<TreeSet<String>, Long> entry : usage.entrySet()) {
            Long value = humanReadable ? NumUtil.bigNumberForSize((long)entry.getValue()) : entry.getValue();
            printer.print(String.format(valueFormat + " %s", value, entry.getKey()));
        }
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        try (TraceScope clientSpan = opts.parseArgsAndTrace(TableDiskUsage.class.getName(), args, new Object[0]);
             AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
            VolumeManager fs = opts.getServerContext().getVolumeManager();
            TableDiskUsage.printDiskUsage(opts.tables, fs, client, false);
        }
    }

    static class Opts
    extends ServerUtilOpts {
        @Parameter(description=" <table> { <table> ... } ")
        List<String> tables = new ArrayList<String>();

        Opts() {
        }
    }

    public static interface Printer {
        public void print(String var1);
    }
}

