/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(TabletBalancer.class);
    protected ServerContext context;
    private static final long ONE_SECOND = 1000L;
    private boolean stuck = false;
    private long stuckNotificationTime = -1L;
    protected static final long TIME_BETWEEN_BALANCER_WARNINGS = 60000L;

    @Deprecated
    public void init(ServerConfigurationFactory conf) {
        this.init(conf.getServerContext());
    }

    public void init(ServerContext context) {
        this.context = context;
    }

    public abstract void getAssignments(SortedMap<TServerInstance, TabletServerStatus> var1, Map<KeyExtent, TServerInstance> var2, Map<KeyExtent, TServerInstance> var3);

    public abstract long balance(SortedMap<TServerInstance, TabletServerStatus> var1, Set<KeyExtent> var2, List<TabletMigration> var3);

    protected void constraintNotMet(BalancerProblem cause) {
        if (!this.stuck) {
            this.stuck = true;
            this.stuckNotificationTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.stuckNotificationTime > 60000L) {
            cause.run();
            this.stuckNotificationTime = System.currentTimeMillis();
        }
    }

    protected void resetBalancerErrors() {
        this.stuck = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TabletStats> getOnlineTabletsForTable(TServerInstance tserver, TableId tableId) throws ThriftSecurityException, TException {
        log.debug("Scanning tablet server {} for table {}", (Object)tserver, (Object)tableId);
        TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (HostAndPort)tserver.getLocation(), (ClientContext)this.context);
        try {
            List list = client.getTabletStats(TraceUtil.traceInfo(), this.context.rpcCreds(), tableId.canonical());
            return list;
        }
        catch (TTransportException e) {
            log.error("Unable to connect to {}: ", (Object)tserver, (Object)e);
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client);
        }
        return null;
    }

    public static List<TabletMigration> checkMigrationSanity(Set<TServerInstance> current, List<TabletMigration> migrations) {
        ArrayList<TabletMigration> result = new ArrayList<TabletMigration>(migrations.size());
        for (TabletMigration m : migrations) {
            if (m.tablet == null) {
                log.warn("Balancer gave back a null tablet {}", (Object)m);
                continue;
            }
            if (m.newServer == null) {
                log.warn("Balancer did not set the destination {}", (Object)m);
                continue;
            }
            if (m.oldServer == null) {
                log.warn("Balancer did not set the source {}", (Object)m);
                continue;
            }
            if (!current.contains(m.oldServer)) {
                log.warn("Balancer wants to move a tablet from a server that is not current: {}", (Object)m);
                continue;
            }
            if (!current.contains(m.newServer)) {
                log.warn("Balancer wants to move a tablet to a server that is not current: {}", (Object)m);
                continue;
            }
            result.add(m);
        }
        return result;
    }

    protected static class OutstandingMigrations
    extends BalancerProblem {
        public Set<KeyExtent> migrations = Collections.emptySet();

        public OutstandingMigrations(Logger logger) {
            super(logger);
        }

        @Override
        public void run() {
            this.balancerLog.warn("Not balancing due to {} outstanding migrations.", (Object)this.migrations.size());
            this.balancerLog.debug("Sample up to 10 outstanding migrations: {}", (Object)Iterables.limit(this.migrations, (int)10));
        }
    }

    protected static class NoTservers
    extends BalancerProblem {
        public NoTservers(Logger logger) {
            super(logger);
        }

        @Override
        public void run() {
            this.balancerLog.warn("Not balancing because we don't have any tservers");
        }
    }

    protected static abstract class BalancerProblem
    implements Runnable {
        protected final Logger balancerLog;

        public BalancerProblem(Logger logger) {
            this.balancerLog = logger;
        }
    }
}

