/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NamespaceConfWatcher
implements Watcher {
    private static final Logger log = LoggerFactory.getLogger(NamespaceConfWatcher.class);
    private final ServerContext context;
    private final String namespacesPrefix;
    private final int namespacesPrefixLength;

    NamespaceConfWatcher(ServerContext context) {
        this.context = context;
        this.namespacesPrefix = context.getZooKeeperRoot() + "/namespaces" + "/";
        this.namespacesPrefixLength = this.namespacesPrefix.length();
    }

    static String toString(WatchedEvent event) {
        return "{path=" + event.getPath() + ",state=" + event.getState() + ",type=" + event.getType() + "}";
    }

    public void process(WatchedEvent event) {
        String path = event.getPath();
        if (log.isTraceEnabled()) {
            log.trace("WatchedEvent : {}", (Object)NamespaceConfWatcher.toString(event));
        }
        String namespaceIdStr = null;
        String key = null;
        if (path != null) {
            if (path.startsWith(this.namespacesPrefix) && (namespaceIdStr = path.substring(this.namespacesPrefixLength)).contains("/")) {
                namespaceIdStr = namespaceIdStr.substring(0, namespaceIdStr.indexOf(47));
                if (path.startsWith(this.namespacesPrefix + namespaceIdStr + "/conf" + "/")) {
                    key = path.substring((this.namespacesPrefix + namespaceIdStr + "/conf" + "/").length());
                }
            }
            if (namespaceIdStr == null) {
                log.warn("Zookeeper told me about a path I was not watching: {}, event {}", (Object)path, (Object)NamespaceConfWatcher.toString(event));
                return;
            }
        }
        NamespaceId namespaceId = NamespaceId.of(namespaceIdStr);
        block0 : switch (event.getType()) {
            case NodeDataChanged: {
                if (log.isTraceEnabled()) {
                    log.trace("EventNodeDataChanged {}", (Object)event.getPath());
                }
                if (key == null) break;
                this.context.getServerConfFactory().getNamespaceConfiguration(namespaceId).propertyChanged(key);
                break;
            }
            case NodeChildrenChanged: {
                this.context.getServerConfFactory().getNamespaceConfiguration(namespaceId).propertiesChanged();
                break;
            }
            case NodeDeleted: {
                if (key != null) break;
                ServerConfigurationFactory.removeCachedNamespaceConfiguration(this.context.getInstanceID(), namespaceId);
                break;
            }
            case None: {
                switch (event.getState()) {
                    case Expired: {
                        log.info("Zookeeper node event type None, state=expired. Expire all table observers");
                        ServerConfigurationFactory.expireAllTableObservers();
                        break block0;
                    }
                    case SyncConnected: {
                        break block0;
                    }
                    case Disconnected: {
                        break block0;
                    }
                }
                log.warn("EventNone event not handled {}", (Object)NamespaceConfWatcher.toString(event));
                break;
            }
            case NodeCreated: {
                switch (event.getState()) {
                    case SyncConnected: {
                        break block0;
                    }
                }
                log.warn("Event NodeCreated event not handled {}", (Object)NamespaceConfWatcher.toString(event));
                break;
            }
            default: {
                log.warn("Event not handled {}", (Object)NamespaceConfWatcher.toString(event));
            }
        }
    }
}

