/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.protobuf.GeneratedMessage;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.master.replication.UnorderedWorkAssigner;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class UnorderedWorkAssignerIT
extends ConfigurableMacBase {
    private AccumuloClient client;
    private MockUnorderedWorkAssigner assigner;

    @Before
    public void init() throws Exception {
        this.client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        this.assigner = new MockUnorderedWorkAssigner(this.client);
        ReplicationTable.setOnline((AccumuloClient)this.client);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.WRITE);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.READ);
    }

    @Test
    public void createWorkForFilesNeedingIt() throws Exception {
        ReplicationTarget target1 = new ReplicationTarget("cluster1", "table1", TableId.of((String)"1"));
        ReplicationTarget target2 = new ReplicationTarget("cluster1", "table2", TableId.of((String)"2"));
        Text serializedTarget1 = target1.toText();
        Text serializedTarget2 = target2.toText();
        String keyTarget1 = target1.getPeerName() + "|" + target1.getRemoteIdentifier() + "|" + target1.getSourceTableId();
        String keyTarget2 = target2.getPeerName() + "|" + target2.getRemoteIdentifier() + "|" + target2.getSourceTableId();
        Replication.Status.Builder builder = Replication.Status.newBuilder().setBegin(0L).setEnd(0L).setInfiniteEnd(true).setClosed(false).setCreatedTime(5L);
        Replication.Status status1 = builder.build();
        builder.setCreatedTime(10L);
        Replication.Status status2 = builder.build();
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        String filename1 = UUID.randomUUID().toString();
        String filename2 = UUID.randomUUID().toString();
        String file1 = "/accumulo/wal/tserver+port/" + filename1;
        String file2 = "/accumulo/wal/tserver+port/" + filename2;
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget1, (Value)ProtobufUtil.toValue((GeneratedMessage)status1));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file1, (long)status1.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (TableId)target1.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)status1));
        bw.addMutation(m);
        m = new Mutation((CharSequence)file2);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget2, (Value)ProtobufUtil.toValue((GeneratedMessage)status2));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file2, (long)status2.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (TableId)target2.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)status2));
        bw.addMutation(m);
        bw.close();
        DistributedWorkQueue workQueue = (DistributedWorkQueue)EasyMock.createMock(DistributedWorkQueue.class);
        HashSet<String> queuedWork = new HashSet<String>();
        this.assigner.setQueuedWork(queuedWork);
        this.assigner.setWorkQueue(workQueue);
        this.assigner.setMaxQueueSize(Integer.MAX_VALUE);
        String key = filename1 + "|" + keyTarget1;
        workQueue.addWork(key, file1);
        EasyMock.expectLastCall().once();
        key = filename2 + "|" + keyTarget2;
        workQueue.addWork(key, file2);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{workQueue});
        this.assigner.createWork();
        EasyMock.verify((Object[])new Object[]{workQueue});
    }

    @Test
    public void doNotCreateWorkForFilesNotNeedingIt() throws Exception {
        ReplicationTarget target1 = new ReplicationTarget("cluster1", "table1", TableId.of((String)"1"));
        ReplicationTarget target2 = new ReplicationTarget("cluster1", "table2", TableId.of((String)"2"));
        Text serializedTarget1 = target1.toText();
        Text serializedTarget2 = target2.toText();
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        String filename1 = UUID.randomUUID().toString();
        String filename2 = UUID.randomUUID().toString();
        String file1 = "/accumulo/wal/tserver+port/" + filename1;
        String file2 = "/accumulo/wal/tserver+port/" + filename2;
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget1, (Value)StatusUtil.fileCreatedValue((long)5L));
        bw.addMutation(m);
        m = new Mutation((CharSequence)file2);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget2, (Value)StatusUtil.fileCreatedValue((long)10L));
        bw.addMutation(m);
        bw.close();
        DistributedWorkQueue workQueue = (DistributedWorkQueue)EasyMock.createMock(DistributedWorkQueue.class);
        HashSet<String> queuedWork = new HashSet<String>();
        this.assigner.setQueuedWork(queuedWork);
        this.assigner.setMaxQueueSize(Integer.MAX_VALUE);
        EasyMock.replay((Object[])new Object[]{workQueue});
        this.assigner.createWork();
        EasyMock.verify((Object[])new Object[]{workQueue});
    }

    @Test
    public void workNotReAdded() throws Exception {
        HashSet<String> queuedWork = new HashSet<String>();
        this.assigner.setQueuedWork(queuedWork);
        ReplicationTarget target = new ReplicationTarget("cluster1", "table1", TableId.of((String)"1"));
        String serializedTarget = target.getPeerName() + "|" + target.getRemoteIdentifier() + "|" + target.getSourceTableId();
        queuedWork.add("wal1|" + serializedTarget);
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        String file1 = "/accumulo/wal/tserver+port/wal1";
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)StatusUtil.openWithUnknownLengthValue());
        bw.addMutation(m);
        bw.close();
        DistributedWorkQueue workQueue = (DistributedWorkQueue)EasyMock.createMock(DistributedWorkQueue.class);
        this.assigner.setWorkQueue(workQueue);
        this.assigner.setMaxQueueSize(Integer.MAX_VALUE);
        EasyMock.replay((Object[])new Object[]{workQueue});
        this.assigner.createWork();
        EasyMock.verify((Object[])new Object[]{workQueue});
    }

    private static class MockUnorderedWorkAssigner
    extends UnorderedWorkAssigner {
        public MockUnorderedWorkAssigner(AccumuloClient client) {
            super(null, client);
        }

        protected void setQueuedWork(Set<String> queuedWork) {
            super.setQueuedWork(queuedWork);
        }

        protected void setWorkQueue(DistributedWorkQueue workQueue) {
            super.setWorkQueue(workQueue);
        }

        protected boolean queueWork(Path path, ReplicationTarget target) {
            return super.queueWork(path, target);
        }

        protected void initializeQueuedWork() {
            super.initializeQueuedWork();
        }

        protected Set<String> getQueuedWork() {
            return super.getQueuedWork();
        }

        protected void setClient(AccumuloClient client) {
            super.setClient(client);
        }

        protected void setMaxQueueSize(int maxQueueSize) {
            super.setMaxQueueSize(maxQueueSize);
        }

        protected void createWork() {
            super.createWork();
        }

        protected void setZooCache(ZooCache zooCache) {
            super.setZooCache(zooCache);
        }

        protected void cleanupFinishedWork() {
            super.cleanupFinishedWork();
        }
    }
}

