/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTserverReplicationIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(MultiTserverReplicationIT.class);

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.REPLICATION_NAME.getKey(), "test");
        cfg.setNumTservers(2);
    }

    @Test
    public void tserverReplicationServicePortsAreAdvertised() throws Exception {
        AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        ClientContext context = (ClientContext)client;
        client.tableOperations().create("foo");
        try (Scanner s = client.createScanner("foo", Authorizations.EMPTY);){
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)s));
            ZooReader zreader = new ZooReader(context.getZooKeepers(), context.getZooKeepersSessionTimeOut());
            HashSet tserverHost = new HashSet();
            tserverHost.addAll(zreader.getChildren(ZooUtil.getRoot((String)client.instanceOperations().getInstanceID()) + "/tservers"));
            HashSet<HostAndPort> replicationServices = new HashSet<HostAndPort>();
            for (String tserver : tserverHost) {
                try {
                    byte[] portData = zreader.getData(ZooUtil.getRoot((String)client.instanceOperations().getInstanceID()) + "/replication/tservers" + "/" + tserver, null);
                    HostAndPort replAddress = HostAndPort.fromString((String)new String(portData, StandardCharsets.UTF_8));
                    replicationServices.add(replAddress);
                }
                catch (Exception e) {
                    log.error("Could not find port for {}", (Object)tserver, (Object)e);
                    Assert.fail((String)("Did not find replication port advertisement for " + tserver));
                }
            }
            Assert.assertEquals((String)"Expected an equal number of replication servicers and tservers", (long)tserverHost.size(), (long)replicationServices.size());
        }
    }

    @Test
    public void masterReplicationServicePortsAreAdvertised() throws Exception {
        AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        ClientContext context = (ClientContext)client;
        client.tableOperations().create("foo");
        try (Scanner s = client.createScanner("foo", Authorizations.EMPTY);){
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)s));
            ZooReader zreader = new ZooReader(context.getZooKeepers(), context.getZooKeepersSessionTimeOut());
            Assert.assertEquals((long)1L, (long)context.getMasterLocations().size());
            String masterAddr = (String)Iterables.getOnlyElement((Iterable)context.getMasterLocations());
            String replCoordAddr = new String(zreader.getData(ZooUtil.getRoot((String)client.instanceOperations().getInstanceID()) + "/masters/repl_coord_addr", null), StandardCharsets.UTF_8);
            Assert.assertNotEquals((Object)masterAddr, (Object)replCoordAddr);
            Assert.assertNotEquals((long)0L, (long)HostAndPort.fromString((String)masterAddr).getPort());
            Assert.assertNotEquals((long)0L, (long)HostAndPort.fromString((String)replCoordAddr).getPort());
        }
    }
}

