/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.protobuf.GeneratedMessage;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.replication.ReplicaSystem;
import org.apache.accumulo.server.replication.ReplicaSystemHelper;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockReplicaSystem
implements ReplicaSystem {
    private static final Logger log = LoggerFactory.getLogger(MockReplicaSystem.class);
    private long sleep = 0L;

    public Replication.Status replicate(Path p, Replication.Status status, ReplicationTarget target, ReplicaSystemHelper helper) {
        Replication.Status newStatus;
        if (status.getClosed() && status.getInfiniteEnd()) {
            Replication.Status.Builder builder = Replication.Status.newBuilder((Replication.Status)status);
            if (status.getInfiniteEnd()) {
                builder.setBegin(Long.MAX_VALUE);
            } else {
                builder.setBegin(status.getEnd());
            }
            newStatus = builder.build();
        } else {
            log.info("{} with status {} is not closed and with infinite length, ignoring", (Object)p, (Object)status);
            newStatus = status;
        }
        log.debug("Sleeping for {}ms before finishing replication on {}", (Object)this.sleep, (Object)p);
        try {
            Thread.sleep(this.sleep);
        }
        catch (InterruptedException e) {
            log.error("Interrupted while sleeping, will report no progress", (Throwable)e);
            Thread.currentThread().interrupt();
            return status;
        }
        log.info("For {}, received {}, returned {}", new Object[]{p, ProtobufUtil.toString((GeneratedMessage)status), ProtobufUtil.toString((GeneratedMessage)newStatus)});
        try {
            helper.recordNewStatus(p, newStatus, target);
        }
        catch (TableNotFoundException e) {
            log.error("Tried to update status in replication table for {} as {}, but the table did not exist", new Object[]{p, ProtobufUtil.toString((GeneratedMessage)newStatus), e});
            return status;
        }
        catch (AccumuloException e) {
            log.error("Tried to record new status in replication table for {} as {}, but got an error", new Object[]{p, ProtobufUtil.toString((GeneratedMessage)newStatus), e});
            return status;
        }
        return newStatus;
    }

    public void configure(ServerContext context, String configuration) {
        if (StringUtils.isBlank((CharSequence)configuration)) {
            log.debug("No configuration, using default sleep of {}", (Object)this.sleep);
            return;
        }
        try {
            this.sleep = Long.parseLong(configuration);
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse {} as an integer, using default sleep of {}", new Object[]{configuration, this.sleep, e});
        }
    }
}

