/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapred;

import java.io.File;
import java.util.HashMap;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.mapred.AccumuloMultiTableInputFormat;
import org.apache.accumulo.core.client.mapred.RangeInputSplit;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class AccumuloMultiTableInputFormatIT
extends AccumuloClusterHarness {
    private static AssertionError e1 = null;
    private static AssertionError e2 = null;

    @Test
    public void testMap() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String table1 = tableNames[0];
        String table2 = tableNames[1];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloMultiTableInputFormatIT.getClientProps()).build();){
            c.tableOperations().create(table1);
            c.tableOperations().create(table2);
            try (BatchWriter bw = c.createBatchWriter(table1);
                 BatchWriter bw2 = c.createBatchWriter(table2);){
                for (int i = 0; i < 100; ++i) {
                    Mutation t1m = new Mutation(new Text(String.format("%s_%09x", table1, i + 1)));
                    t1m.put(new Text(), new Text(), new Value(String.format("%s_%09x", table1, i).getBytes()));
                    bw.addMutation(t1m);
                    Mutation t2m = new Mutation(new Text(String.format("%s_%09x", table2, i + 1)));
                    t2m.put(new Text(), new Text(), new Value(String.format("%s_%09x", table2, i).getBytes()));
                    bw2.addMutation(t2m);
                }
            }
            MRTester.main(new String[]{table1, table2});
            Assert.assertNull((Object)e1);
            Assert.assertNull((Object)e2);
        }
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table1> <table2>");
            }
            String table1 = args[0];
            String table2 = args[1];
            JobConf job = new JobConf(this.getConf());
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormat(AccumuloMultiTableInputFormat.class);
            ClientInfo ci = AccumuloClusterHarness.getClientInfo();
            AccumuloMultiTableInputFormat.setZooKeeperInstance((JobConf)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloMultiTableInputFormat.setConnectorInfo((JobConf)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            InputTableConfig tableConfig1 = new InputTableConfig();
            InputTableConfig tableConfig2 = new InputTableConfig();
            HashMap<String, InputTableConfig> configMap = new HashMap<String, InputTableConfig>();
            configMap.put(table1, tableConfig1);
            configMap.put(table2, tableConfig2);
            AccumuloMultiTableInputFormat.setInputTableConfigs((JobConf)job, configMap);
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormat(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            return JobClient.runJob((JobConf)job).isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class TestMapper
        implements Mapper<Key, Value, Key, Value> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            public void map(Key k, Value v, OutputCollector<Key, Value> output, Reporter reporter) {
                try {
                    String tableName = ((RangeInputSplit)reporter.getInputSplit()).getTableName();
                    if (this.key != null) {
                        Assert.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assert.assertEquals((Object)new Text(String.format("%s_%09x", tableName, this.count + 1)), (Object)k.getRow());
                    Assert.assertEquals((Object)String.format("%s_%09x", tableName, this.count), (Object)new String(v.get()));
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                this.key = new Key(k);
                ++this.count;
            }

            public void configure(JobConf job) {
            }

            public void close() {
                try {
                    Assert.assertEquals((long)100L, (long)this.count);
                }
                catch (AssertionError e) {
                    e2 = e;
                }
            }
        }
    }
}

