/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TabletStateChangeIteratorIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 180;
    }

    @Test
    public void test() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(TabletStateChangeIteratorIT.getClientProps()).build();){
            String[] tables = this.getUniqueNames(4);
            String t1 = tables[0];
            String t2 = tables[1];
            final String t3 = tables[2];
            String cloned = tables[3];
            this.createTable(client, t1, true);
            this.createTable(client, t2, false);
            this.createTable(client, t3, true);
            this.cloneMetadataTable(client, cloned);
            State state = new State(client);
            while (this.findTabletsNeedingAttention(client, cloned, state) > 0) {
                UtilWaitThread.sleep((long)500L);
            }
            Assert.assertEquals((String)"No tables should need attention", (long)0L, (long)this.findTabletsNeedingAttention(client, cloned, state));
            this.removeLocation(client, cloned, t3);
            Assert.assertEquals((String)"Should have two tablets without a loc", (long)2L, (long)this.findTabletsNeedingAttention(client, cloned, state));
            client.tableOperations().delete(cloned);
            this.cloneMetadataTable(client, cloned);
            this.reassignLocation(client, cloned, t3);
            Assert.assertEquals((String)"Should have one tablet that needs to be unassigned", (long)1L, (long)this.findTabletsNeedingAttention(client, cloned, state));
            state = new State(client){

                @Override
                public Collection<MergeInfo> merges() {
                    TableId tableIdToModify = TableId.of((String)((String)this.client.tableOperations().tableIdMap().get(t3)));
                    return Collections.singletonList(new MergeInfo(new KeyExtent(tableIdToModify, null, null), MergeInfo.Operation.MERGE));
                }
            };
            Assert.assertEquals((String)"Should have 2 tablets that need to be chopped or unassigned", (long)1L, (long)this.findTabletsNeedingAttention(client, cloned, state));
            state = new State(client);
            this.cloneMetadataTable(client, cloned);
            this.addDuplicateLocation(client, cloned, t3);
            Assert.assertEquals((String)"Should have 1 tablet that needs a metadata repair", (long)1L, (long)this.findTabletsNeedingAttention(client, cloned, state));
            this.dropTables(client, t1, t2, t3, cloned);
        }
    }

    private void addDuplicateLocation(AccumuloClient client, String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        TableId tableIdToModify = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableNameToModify)));
        Mutation m = new Mutation(new KeyExtent(tableIdToModify, null, null).getMetadataEntry());
        m.put(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, new Text("1234567"), new Value("fake:9005".getBytes(StandardCharsets.UTF_8)));
        try (BatchWriter bw = client.createBatchWriter(table);){
            bw.addMutation(m);
        }
    }

    private void reassignLocation(AccumuloClient client, String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        TableId tableIdToModify = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableNameToModify)));
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            scanner.setRange(new KeyExtent(tableIdToModify, null, null).toMetadataRange());
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            Map.Entry entry = (Map.Entry)scanner.iterator().next();
            Mutation m = new Mutation(((Key)entry.getKey()).getRow());
            m.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier(), ((Key)entry.getKey()).getTimestamp());
            m.put(((Key)entry.getKey()).getColumnFamily(), new Text("1234567"), ((Key)entry.getKey()).getTimestamp() + 1L, new Value("fake:9005".getBytes(StandardCharsets.UTF_8)));
            try (BatchWriter bw = client.createBatchWriter(table);){
                bw.addMutation(m);
            }
        }
    }

    private void removeLocation(AccumuloClient client, String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        TableId tableIdToModify = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableNameToModify)));
        BatchDeleter deleter = client.createBatchDeleter(table, Authorizations.EMPTY, 1, new BatchWriterConfig());
        deleter.setRanges(Collections.singleton(new KeyExtent(tableIdToModify, null, null).toMetadataRange()));
        deleter.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        deleter.delete();
        deleter.close();
    }

    private int findTabletsNeedingAttention(AccumuloClient client, String table, State state) throws TableNotFoundException {
        int results = 0;
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            MetaDataTableScanner.configureScanner((ScannerBase)scanner, (CurrentState)state);
            scanner.updateScanIteratorOption("tabletChange", "debug", "1");
            for (Map.Entry e : scanner) {
                if (e == null) continue;
                ++results;
            }
        }
        return results;
    }

    private void createTable(AccumuloClient client, String t, boolean online) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, TableExistsException {
        client.tableOperations().create(t);
        client.tableOperations().online(t, true);
        TreeSet<Text> partitionKeys = new TreeSet<Text>();
        partitionKeys.add(new Text("some split"));
        client.tableOperations().addSplits(t, partitionKeys);
        if (!online) {
            client.tableOperations().offline(t, true);
        }
    }

    private void cloneMetadataTable(AccumuloClient client, String cloned) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        try {
            this.dropTables(client, cloned);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        client.tableOperations().clone(MetadataTable.NAME, cloned, true, null, null);
    }

    private void dropTables(AccumuloClient client, String ... tables) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        for (String t : tables) {
            client.tableOperations().delete(t);
        }
    }

    private class State
    implements CurrentState {
        final AccumuloClient client;

        State(AccumuloClient client) {
            this.client = client;
        }

        public Set<TServerInstance> onlineTabletServers() {
            HashSet<TServerInstance> tservers = new HashSet<TServerInstance>();
            for (String tserver : this.client.instanceOperations().getTabletServers()) {
                try {
                    String zPath = ZooUtil.getRoot((String)this.client.instanceOperations().getInstanceID()) + "/tservers" + "/" + tserver;
                    ClientInfo info = AccumuloClusterHarness.getClientInfo();
                    long sessionId = ZooLock.getSessionId((ZooCache)new ZooCache(info.getZooKeepers(), info.getZooKeepersSessionTimeOut()), (String)zPath);
                    tservers.add(new TServerInstance(tserver, sessionId));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return tservers;
        }

        public Set<TableId> onlineTables() {
            ClientContext context = (ClientContext)this.client;
            Set onlineTables = Tables.getIdToNameMap((ClientContext)context).keySet();
            return Sets.filter(onlineTables, tableId -> Tables.getTableState((ClientContext)context, (TableId)tableId) == TableState.ONLINE);
        }

        public Collection<MergeInfo> merges() {
            return Collections.emptySet();
        }

        public Set<KeyExtent> migrationsSnapshot() {
            return Collections.emptySet();
        }

        public Set<TServerInstance> shutdownServers() {
            return Collections.emptySet();
        }

        public MasterState getMasterState() {
            return MasterState.NORMAL;
        }
    }
}

