/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.client.summary.CounterSummary;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.client.summary.summarizers.FamilySummarizer;
import org.apache.accumulo.core.client.summary.summarizers.VisibilitySummarizer;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.BasicSummarizer;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class SummaryIT
extends AccumuloClusterHarness {
    private LongSummaryStatistics getTimestampStats(String table, AccumuloClient c) throws TableNotFoundException {
        try (Scanner scanner = c.createScanner(table, Authorizations.EMPTY);){
            Stream<Map.Entry> stream = StreamSupport.stream(scanner.spliterator(), false);
            LongSummaryStatistics longSummaryStatistics = stream.mapToLong(e -> ((Key)e.getKey()).getTimestamp()).summaryStatistics();
            return longSummaryStatistics;
        }
    }

    private LongSummaryStatistics getTimestampStats(String table, AccumuloClient c, String startRow, String endRow) throws TableNotFoundException {
        try (Scanner scanner = c.createScanner(table, Authorizations.EMPTY);){
            scanner.setRange(new Range((CharSequence)startRow, false, (CharSequence)endRow, true));
            Stream<Map.Entry> stream = StreamSupport.stream(scanner.spliterator(), false);
            LongSummaryStatistics longSummaryStatistics = stream.mapToLong(e -> ((Key)e.getKey()).getTimestamp()).summaryStatistics();
            return longSummaryStatistics;
        }
    }

    private void checkSummaries(Collection<Summary> summaries, SummarizerConfiguration sc, int total, int missing, int extra, Object ... kvs) {
        Summary summary = (Summary)Iterables.getOnlyElement(summaries);
        Assert.assertEquals((String)"total wrong", (long)total, (long)summary.getFileStatistics().getTotal());
        Assert.assertEquals((String)"missing wrong", (long)missing, (long)summary.getFileStatistics().getMissing());
        Assert.assertEquals((String)"extra wrong", (long)extra, (long)summary.getFileStatistics().getExtra());
        Assert.assertEquals((String)"deleted wrong", (long)0L, (long)summary.getFileStatistics().getDeleted());
        Assert.assertEquals((Object)sc, (Object)summary.getSummarizerConfiguration());
        HashMap<String, Long> expected = new HashMap<String, Long>();
        for (int i = 0; i < kvs.length; i += 2) {
            expected.put((String)kvs[i], (Long)kvs[i + 1]);
        }
        Assert.assertEquals(expected, (Object)summary.getStatistics());
    }

    private void addSplits(String table, AccumuloClient c, String ... splits) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        c.tableOperations().addSplits(table, new TreeSet(Lists.transform(Arrays.asList(splits), Text::new)));
    }

    @Test
    public void basicSummaryTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder((String)BasicSummarizer.class.getName()).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            BatchWriter bw = this.writeData(table, c);
            List summaries = c.tableOperations().summaries(table).flush(false).retrieve();
            Assert.assertEquals((long)0L, (long)summaries.size());
            LongSummaryStatistics stats = this.getTimestampStats(table, c);
            summaries = c.tableOperations().summaries(table).flush(true).retrieve();
            this.checkSummaries(summaries, sc1, 1, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            Mutation m = new Mutation((CharSequence)String.format("r%09x", 999));
            m.put((CharSequence)"f1", (CharSequence)"q1", (CharSequence)"999-0");
            m.putDelete((CharSequence)"f1", (CharSequence)"q2");
            bw.addMutation(m);
            bw.flush();
            c.tableOperations().flush(table, null, null, true);
            stats = this.getTimestampStats(table, c);
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 2, 0, 0, "total", 100002L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 1L);
            bw.close();
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 1, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            String sp1 = String.format("r%09x", 50000);
            this.addSplits(table, c, sp1);
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 1, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            c.tableOperations().compact(table, new CompactionConfig().setStartRow(new Text(sp1)).setWait(true));
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 2, 0, 1, "total", 113999L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            stats = this.getTimestampStats(table, c, sp1, null);
            summaries = c.tableOperations().summaries(table).startRow((CharSequence)sp1).retrieve();
            this.checkSummaries(summaries, sc1, 1, 0, 0, "total", 49999L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            c.tableOperations().compact(table, new CompactionConfig());
            summaries = c.tableOperations().summaries(table).retrieve();
            stats = this.getTimestampStats(table, c);
            this.checkSummaries(summaries, sc1, 2, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            summaries = c.tableOperations().summaries(table).startRow((CharSequence)String.format("r%09x", 75000)).endRow((CharSequence)String.format("r%09x", 80000)).retrieve();
            Summary summary = (Summary)Iterables.getOnlyElement((Iterable)summaries);
            Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getTotal());
            Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getExtra());
            long total = (Long)summary.getStatistics().get("total");
            Assert.assertTrue((String)("Total " + total + " out of expected range"), (total > 0L && total <= 10000L ? 1 : 0) != 0);
            c.tableOperations().removeSummarizers(table, sc -> sc.getClassName().contains("foo"));
            List summarizers = c.tableOperations().listSummarizers(table);
            Assert.assertEquals((long)1L, (long)summarizers.size());
            Assert.assertTrue((boolean)summarizers.contains(sc1));
            c.tableOperations().removeSummarizers(table, sc -> sc.getClassName().equals(BasicSummarizer.class.getName()));
            summarizers = c.tableOperations().listSummarizers(table);
            Assert.assertEquals((long)0L, (long)summarizers.size());
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            summaries = c.tableOperations().summaries(table).retrieve();
            Assert.assertEquals((long)0L, (long)summaries.size());
            c.tableOperations().addSummarizers(table, new SummarizerConfiguration[]{sc1});
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 2, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
        }
    }

    private BatchWriter writeData(String table, AccumuloClient c) throws TableNotFoundException, MutationsRejectedException {
        BatchWriter bw = c.createBatchWriter(table);
        for (int i = 0; i < 100000; ++i) {
            Mutation m = new Mutation((CharSequence)String.format("r%09x", i));
            m.put((CharSequence)"f1", (CharSequence)"q1", (CharSequence)("" + i));
            bw.addMutation(m);
        }
        bw.flush();
        return bw;
    }

    private static void checkSummary(Collection<Summary> summaries, SummarizerConfiguration sc, Object ... stats) {
        HashMap<String, Long> expected = new HashMap<String, Long>();
        for (int i = 0; i < stats.length; i += 2) {
            expected.put((String)stats[i], (Long)stats[i + 1]);
        }
        for (Summary summary : summaries) {
            if (!summary.getSummarizerConfiguration().equals((Object)sc)) continue;
            Assert.assertEquals(expected, (Object)summary.getStatistics());
            return;
        }
        Assert.fail((String)("Did not find summary with config : " + sc));
    }

    @Test
    public void selectionTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(BasicSummarizer.class).build();
            SummarizerConfiguration sc2 = SummarizerConfiguration.builder(KeySizeSummarizer.class).addOption("maxLen", "512").build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1, sc2});
            c.tableOperations().create(table, ntc);
            BatchWriter bw = this.writeData(table, c);
            bw.close();
            c.tableOperations().flush(table, null, null, true);
            LongSummaryStatistics stats = this.getTimestampStats(table, c);
            List summaries = c.tableOperations().summaries(table).withConfiguration(new SummarizerConfiguration[]{sc2}).retrieve();
            Assert.assertEquals((long)1L, (long)summaries.size());
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            summaries = c.tableOperations().summaries(table).withConfiguration(new SummarizerConfiguration[]{sc1}).retrieve();
            Assert.assertEquals((long)1L, (long)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            SummarizerConfiguration sc3 = SummarizerConfiguration.builder((String)KeySizeSummarizer.class.getName()).addOption("maxLen", "256").build();
            summaries = c.tableOperations().summaries(table).withConfiguration(new SummarizerConfiguration[]{sc3}).retrieve();
            Assert.assertEquals((long)0L, (long)summaries.size());
            summaries = c.tableOperations().summaries(table).withConfiguration(new SummarizerConfiguration[]{sc1, sc2}).retrieve();
            Assert.assertEquals((long)2L, (long)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            summaries = c.tableOperations().summaries(table).retrieve();
            Assert.assertEquals((long)2L, (long)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*BasicSummarizer \\{\\}.*").retrieve();
            Assert.assertEquals((long)1L, (long)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*KeySizeSummarizer \\{maxLen=512\\}.*").retrieve();
            Assert.assertEquals((long)1L, (long)summaries.size());
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*KeySizeSummarizer \\{maxLen=256\\}.*").retrieve();
            Assert.assertEquals((long)0L, (long)summaries.size());
            summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*BasicSummarizer \\{\\}.*").withConfiguration(new SummarizerConfiguration[]{sc2}).retrieve();
            Assert.assertEquals((long)2L, (long)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            try {
                summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*KeySizeSummarizer {maxLen=256}.*").retrieve();
                Assert.fail((String)"Bad regex should have caused exception");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    @Test
    public void compactionTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            Map counts;
            Stream<Map.Entry> stream;
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder((String)FooCounter.class.getName()).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "bar1", "f1", "q1", "v1");
                this.write(bw, "bar2", "f1", "q1", "v2");
                this.write(bw, "foo1", "f1", "q1", "v3");
            }
            CompactionStrategyConfig csc = new CompactionStrategyConfig(FooCS.class.getName());
            List<IteratorSetting> iterators = Collections.singletonList(new IteratorSetting(100, FooFilter.class));
            CompactionConfig compactConfig = new CompactionConfig().setFlush(true).setCompactionStrategy(csc).setIterators(iterators).setWait(true);
            c.tableOperations().compact(table, compactConfig);
            try (Scanner scanner = c.createScanner(table, Authorizations.EMPTY);){
                stream = StreamSupport.stream(scanner.spliterator(), false);
                counts = stream.map(e -> ((Key)e.getKey()).getRowData().toString()).map(r -> r.replaceAll("[0-9]+", "")).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                Assert.assertEquals((long)1L, (long)counts.getOrDefault("foo", 0L));
                Assert.assertEquals((long)2L, (long)counts.getOrDefault("bar", 0L));
                Assert.assertEquals((long)2L, (long)counts.size());
            }
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "foo2", "f1", "q1", "v4");
                this.write(bw, "foo3", "f1", "q1", "v5");
                this.write(bw, "foo4", "f1", "q1", "v6");
            }
            c.tableOperations().compact(table, compactConfig);
            scanner = c.createScanner(table, Authorizations.EMPTY);
            try {
                stream = StreamSupport.stream(scanner.spliterator(), false);
                counts = stream.map(e -> ((Key)e.getKey()).getRowData().toString()).map(r -> r.replaceAll("[0-9]+", "")).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                Assert.assertEquals((long)0L, (long)counts.getOrDefault("foo", 0L));
                Assert.assertEquals((long)2L, (long)counts.getOrDefault("bar", 0L));
                Assert.assertEquals((long)1L, (long)counts.size());
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }

    @Test
    public void testBuggySummarizer() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(BuggySummarizer.class).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            c.tableOperations().addSplits(table, new TreeSet<Text>(Collections.singleton(new Text("g"))));
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "bar1", "f1", "q1", "v1");
                this.write(bw, "bar2", "f1", "q1", "v2");
                this.write(bw, "foo1", "f1", "q1", "v3");
            }
            c.tableOperations().flush(table, null, null, true);
            try {
                c.tableOperations().summaries(table).retrieve();
                Assert.fail((String)"Expected server side failure and did not see it");
            }
            catch (AccumuloServerException accumuloServerException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testPermissions() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(FooCounter.class).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "bar1", "f1", "q1", "v1");
                this.write(bw, "bar2", "f1", "q1", "v2");
                this.write(bw, "foo1", "f1", "q1", "v3");
            }
            c.tableOperations().flush(table, null, null, true);
            PasswordToken passTok = new PasswordToken((CharSequence)"letmesee");
            c.securityOperations().createLocalUser("user1", passTok);
            try (AccumuloClient c2 = (AccumuloClient)Accumulo.newClient().from(c.properties()).as((CharSequence)"user1", (AuthenticationToken)passTok).build();){
                try {
                    c2.tableOperations().summaries(table).retrieve();
                    Assert.fail((String)"Expected operation to fail because user does not have permssion to get summaries");
                }
                catch (AccumuloSecurityException ase) {
                    Assert.assertEquals((Object)SecurityErrorCode.PERMISSION_DENIED, (Object)ase.getSecurityErrorCode());
                }
                c.securityOperations().grantTablePermission("user1", table, TablePermission.GET_SUMMARIES);
                for (int tries = 0; tries < 10; ++tries) {
                    try {
                        Summary summary = (Summary)c2.tableOperations().summaries(table).retrieve().get(0);
                        Assert.assertEquals((long)2L, (long)summary.getStatistics().size());
                        Assert.assertEquals((long)2L, (long)summary.getStatistics().getOrDefault("bars", 0L));
                        Assert.assertEquals((long)1L, (long)summary.getStatistics().getOrDefault("foos", 0L));
                        break;
                    }
                    catch (AccumuloSecurityException ase) {
                        UtilWaitThread.sleep((long)500L);
                        continue;
                    }
                }
            }
        }
    }

    @Test
    public void tooLargeTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(BigSummarizer.class).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "a_large", "f1", "q1", "v1");
                this.write(bw, "v_small", "f1", "q1", "v2");
            }
            c.tableOperations().flush(table, null, null, true);
            Summary summary = (Summary)c.tableOperations().summaries(table).retrieve().get(0);
            Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getLarge());
            Assert.assertEquals((long)0L, (long)summary.getFileStatistics().getMissing());
            Assert.assertEquals((long)0L, (long)summary.getFileStatistics().getExtra());
            Assert.assertEquals((long)0L, (long)summary.getFileStatistics().getDeleted());
            Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getInaccurate());
            Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getTotal());
            Assert.assertEquals(Collections.emptyMap(), (Object)summary.getStatistics());
            c.tableOperations().addSplits(table, new TreeSet<Text>(Collections.singleton(new Text("m"))));
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            summary = (Summary)c.tableOperations().summaries(table).retrieve().get(0);
            Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getLarge());
            Assert.assertEquals((long)0L, (long)summary.getFileStatistics().getMissing());
            Assert.assertEquals((long)0L, (long)summary.getFileStatistics().getExtra());
            Assert.assertEquals((long)0L, (long)summary.getFileStatistics().getDeleted());
            Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getInaccurate());
            Assert.assertEquals((long)2L, (long)summary.getFileStatistics().getTotal());
            HashMap<String, Long> expected = new HashMap<String, Long>();
            for (int i = 0; i < 10; ++i) {
                expected.put(String.format("%09x", i), (long)i * 19L);
            }
            Assert.assertEquals(expected, (Object)summary.getStatistics());
        }
    }

    private void write(BatchWriter bw, String row, String family, String qualifier, String value) throws MutationsRejectedException {
        Mutation m1 = new Mutation((CharSequence)row);
        m1.put((CharSequence)family, (CharSequence)qualifier, (CharSequence)value);
        bw.addMutation(m1);
    }

    private void write(BatchWriter bw, Map<Key, Value> expected, String row, String family, String qualifier, long ts, String value) throws MutationsRejectedException {
        Mutation m1 = new Mutation((CharSequence)row);
        m1.put((CharSequence)family, (CharSequence)qualifier, ts, (CharSequence)value);
        bw.addMutation(m1);
        expected.put(Key.builder().row((CharSequence)row).family((CharSequence)family).qualifier((CharSequence)qualifier).timestamp(ts).build(), new Value((CharSequence)value));
    }

    private Map<String, Long> nm(Object ... entries) {
        ImmutableMap.Builder imb = ImmutableMap.builder();
        for (int i = 0; i < entries.length; i += 2) {
            imb.put((Object)((String)entries[i]), (Object)((Long)entries[i + 1]));
        }
        return imb.build();
    }

    @Test
    public void testLocalityGroups() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(FamilySummarizer.class).build();
            SummarizerConfiguration sc2 = SummarizerConfiguration.builder(BasicSummarizer.class).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1, sc2});
            HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
            lgroups.put("lg1", ImmutableSet.of((Object)new Text("chocolate"), (Object)new Text("coffee")));
            lgroups.put("lg2", ImmutableSet.of((Object)new Text(" broccoli "), (Object)new Text("cabbage")));
            lgroups.put("lg3", ImmutableSet.of((Object)new Text(" apple "), (Object)new Text("orange")));
            ntc.setLocalityGroups(lgroups);
            c.tableOperations().create(table, ntc);
            HashMap<Key, Value> expected = new HashMap<Key, Value>();
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, expected, "order:001", "chocolate", "dark", 3L, "99kg");
                this.write(bw, expected, "order:001", "chocolate", "light", 4L, "94kg");
                this.write(bw, expected, "order:001", "coffee", "dark", 5L, "33kg");
                this.write(bw, expected, "order:001", "broccoli", "crowns", 6L, "2kg");
                this.write(bw, expected, "order:001", "cheddar", "canadian", 7L, "40kg");
                this.write(bw, expected, "order:653", "chocolate", "dark", 3L, "3kg");
                this.write(bw, expected, "order:653", "chocolate", "light", 4L, "4kg");
                this.write(bw, expected, "order:653", "coffee", "dark", 5L, "2kg");
                this.write(bw, expected, "order:653", "broccoli", "crowns", 6L, "105kg");
                this.write(bw, expected, "order:653", "cabbage", "heads", 7L, "199kg");
                this.write(bw, expected, "order:653", "cheddar", "canadian", 8L, "43kg");
            }
            List summaries = c.tableOperations().summaries(table).flush(true).retrieve();
            Assert.assertEquals((long)2L, (long)summaries.stream().map(Summary::getSummarizerConfiguration).distinct().count());
            for (Summary summary : summaries) {
                Map<String, Long> expectedStats;
                if (summary.getSummarizerConfiguration().equals((Object)sc1)) {
                    expectedStats = this.nm("c:chocolate", 4L, "c:coffee", 2L, "c:broccoli", 2L, "c:cheddar", 2L, "c:cabbage", 1L, "tooLong", 0L, "tooMany", 0L, "seen", 11L, "emitted", 11L, "deletesIgnored", 0L);
                    Assert.assertEquals(expectedStats, (Object)summary.getStatistics());
                    Assert.assertEquals((long)0L, (long)summary.getFileStatistics().getInaccurate());
                    Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getTotal());
                    continue;
                }
                if (summary.getSummarizerConfiguration().equals((Object)sc2)) {
                    expectedStats = this.nm("deletes", 0L, "total", 11L, "minTimestamp", 3L, "maxTimestamp", 8L);
                    Assert.assertEquals(expectedStats, (Object)summary.getStatistics());
                    Assert.assertEquals((long)0L, (long)summary.getFileStatistics().getInaccurate());
                    Assert.assertEquals((long)1L, (long)summary.getFileStatistics().getTotal());
                    continue;
                }
                Assert.fail((String)("unexpected summary config " + summary.getSummarizerConfiguration()));
            }
            HashMap actual = new HashMap();
            c.createScanner(table, Authorizations.EMPTY).forEach(e -> actual.put((Key)e.getKey(), (Value)e.getValue()));
            Assert.assertEquals(expected, actual);
        }
    }

    @Test
    public void testExceptions() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            try {
                c.tableOperations().summaries("foo").retrieve();
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            try {
                c.tableOperations().addSummarizers("foo", new SummarizerConfiguration[]{SummarizerConfiguration.builder(VisibilitySummarizer.class).build()});
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            try {
                c.tableOperations().listSummarizers("foo");
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            try {
                c.tableOperations().removeSummarizers("foo", sc -> true);
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(FamilySummarizer.class).setPropertyId("p1").build();
            SummarizerConfiguration sc2 = SummarizerConfiguration.builder(VisibilitySummarizer.class).setPropertyId("p1").build();
            c.tableOperations().create("foo");
            c.tableOperations().addSummarizers("foo", new SummarizerConfiguration[]{sc1});
            c.tableOperations().addSummarizers("foo", new SummarizerConfiguration[]{sc1});
            try {
                c.tableOperations().addSummarizers("foo", new SummarizerConfiguration[]{sc2});
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            c.tableOperations().removeSummarizers("foo", sc -> true);
            Assert.assertEquals((long)0L, (long)c.tableOperations().listSummarizers("foo").size());
            try {
                c.tableOperations().addSummarizers("foo", new SummarizerConfiguration[]{sc1, sc2});
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)c.tableOperations().listSummarizers("foo").size());
            c.tableOperations().offline("foo", true);
            try {
                c.tableOperations().summaries("foo").retrieve();
                Assert.fail();
            }
            catch (TableOfflineException tableOfflineException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testManyFiles() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            ntc.enableSummarization(new SummarizerConfiguration[]{SummarizerConfiguration.builder(FamilySummarizer.class).build()});
            c.tableOperations().create(table, ntc);
            SecureRandom rand = new SecureRandom();
            int q = 0;
            TreeSet<Text> partitionKeys = new TreeSet<Text>();
            for (int split = 100000; split < 1000000; split += 100000) {
                partitionKeys.add(new Text(String.format("%06d", split)));
            }
            c.tableOperations().addSplits(table, partitionKeys);
            HashMap<String, Long> famCounts = new HashMap<String, Long>();
            for (int t = 0; t < 20; ++t) {
                try (BatchWriter bw = c.createBatchWriter(table);){
                    for (int i = 0; i < 10000; ++i) {
                        String row = String.format("%06d", rand.nextInt(1000000));
                        String fam = String.format("%03d", rand.nextInt(100));
                        String qual = String.format("%06d", q++);
                        this.write(bw, row, fam, qual, "val");
                        famCounts.merge(fam, 1L, Long::sum);
                    }
                }
                List summaries = c.tableOperations().summaries(table).flush(true).retrieve();
                Assert.assertEquals((long)1L, (long)summaries.size());
                CounterSummary cs = new CounterSummary((Summary)summaries.get(0));
                Assert.assertEquals(famCounts, (Object)cs.getCounters());
                Summary.FileStatistics fileStats = ((Summary)summaries.get(0)).getFileStatistics();
                Assert.assertEquals((long)0L, (long)fileStats.getInaccurate());
                Assert.assertTrue((String)("Saw " + fileStats.getTotal() + " files expected >=10"), (fileStats.getTotal() >= 10L ? 1 : 0) != 0);
            }
        }
    }

    public static class BigSummarizer
    implements Summarizer {
        public Summarizer.Collector collector(SummarizerConfiguration sc) {
            return new Summarizer.Collector(){
                private int num = 10;

                public void accept(Key k, Value v) {
                    if (k.getRowData().toString().contains("large")) {
                        this.num = 100000;
                    }
                }

                public void summarize(Summarizer.StatisticConsumer sc) {
                    for (int i = 0; i < this.num; ++i) {
                        sc.accept(String.format("%09x", i), (long)(i * 19));
                    }
                }
            };
        }

        public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
            return (m1, m2) -> m2.forEach((k, v) -> m1.merge(k, v, Long::sum));
        }
    }

    public static class BuggySummarizer
    extends FooCounter {
        @Override
        public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
            return (m1, m2) -> {
                throw new NullPointerException();
            };
        }
    }

    public static class FooCS
    extends CompactionStrategy {
        private boolean compact = false;

        public boolean shouldCompact(MajorCompactionRequest request) {
            return true;
        }

        public void gatherInformation(MajorCompactionRequest request) {
            List summaries = request.getSummaries(request.getFiles().keySet(), conf -> conf.getClassName().contains("FooCounter"));
            if (summaries.size() == 1) {
                Summary summary = (Summary)summaries.get(0);
                Long foos = summary.getStatistics().getOrDefault("foos", 0L);
                Long bars = summary.getStatistics().getOrDefault("bars", 0L);
                this.compact = foos > bars;
            }
        }

        public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
            if (this.compact) {
                CompactionPlan cp = new CompactionPlan();
                cp.inputFiles.addAll(request.getFiles().keySet());
                return cp;
            }
            return null;
        }
    }

    public static class FooFilter
    extends Filter {
        public boolean accept(Key k, Value v) {
            return !k.getRowData().toString().contains("foo");
        }
    }

    public static class FooCounter
    implements Summarizer {
        public Summarizer.Collector collector(SummarizerConfiguration sc) {
            return new Summarizer.Collector(){
                long foos = 0L;
                long bars = 0L;

                public void accept(Key k, Value v) {
                    String row = k.getRowData().toString();
                    if (row.contains("foo")) {
                        ++this.foos;
                    } else if (row.contains("bar")) {
                        ++this.bars;
                    }
                }

                public void summarize(Summarizer.StatisticConsumer sc) {
                    sc.accept("foos", this.foos);
                    sc.accept("bars", this.bars);
                }
            };
        }

        public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
            return (m1, m2) -> m2.forEach((k, v) -> m1.merge(k, v, Long::sum));
        }
    }

    public static class KeySizeSummarizer
    implements Summarizer {
        public Summarizer.Collector collector(final SummarizerConfiguration sc) {
            return new Summarizer.Collector(){
                private int maxLen;
                private long[] lengths;
                private long overMax;
                {
                    this.maxLen = Integer.parseInt(sc.getOptions().getOrDefault("maxLen", "1024"));
                    this.lengths = new long[this.maxLen];
                    this.overMax = 0L;
                }

                public void accept(Key k, Value v) {
                    int size = k.getSize();
                    if (size >= this.maxLen) {
                        ++this.overMax;
                    } else {
                        int n = size;
                        this.lengths[n] = this.lengths[n] + 1L;
                    }
                }

                public void summarize(Summarizer.StatisticConsumer sc2) {
                    if (this.overMax > 0L) {
                        sc2.accept("len>=" + this.maxLen, this.overMax);
                    }
                    for (int i = 0; i < this.lengths.length; ++i) {
                        if (this.lengths[i] <= 0L) continue;
                        sc2.accept("len=" + i, this.lengths[i]);
                    }
                }
            };
        }

        public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
            return (m1, m2) -> m2.forEach((k, v) -> m1.merge(k, v, Long::sum));
        }
    }
}

