/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.util.CheckForMetadataProblems;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.DeleteIT;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(SplitIT.class);
    private String tservMaxMem;
    private String tservMajcDelay;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAXMEM, "5K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "100ms");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Before
    public void alterConfig() throws Exception {
        Assume.assumeTrue((SplitIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            InstanceOperations iops = client.instanceOperations();
            Map config = iops.getSystemConfiguration();
            this.tservMaxMem = (String)config.get(Property.TSERV_MAXMEM.getKey());
            this.tservMajcDelay = (String)config.get(Property.TSERV_MAJC_DELAY.getKey());
            if (!this.tservMajcDelay.equals("100ms")) {
                iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), "100ms");
            }
            boolean restarted = false;
            if (!this.tservMaxMem.equals("5K")) {
                iops.setProperty(Property.TSERV_MAXMEM.getKey(), "5K");
                SplitIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                SplitIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
                restarted = true;
            }
            if (!restarted) {
                long millis = ConfigurationTypeHelper.getTimeInMillis((String)this.tservMajcDelay);
                log.info("Waiting for majc delay period: {}ms", (Object)millis);
                Thread.sleep(millis);
                log.info("Finished waiting for majc delay period");
            }
        }
    }

    @After
    public void resetConfig() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            if (this.tservMaxMem != null) {
                log.info("Resetting {}={}", (Object)Property.TSERV_MAXMEM.getKey(), (Object)this.tservMaxMem);
                client.instanceOperations().setProperty(Property.TSERV_MAXMEM.getKey(), this.tservMaxMem);
                this.tservMaxMem = null;
                SplitIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                SplitIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            }
            if (this.tservMajcDelay != null) {
                log.info("Resetting {}={}", (Object)Property.TSERV_MAJC_DELAY.getKey(), (Object)this.tservMajcDelay);
                client.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.tservMajcDelay);
                this.tservMajcDelay = null;
            }
        }
    }

    @Test
    public void tabletShouldSplit() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "256K");
            props.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "1K");
            c.tableOperations().create(table, new NewTableConfiguration().setProperties(props));
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(SplitIT.getClientProps(), table, 100000);
            TestIngest.ingest(c, params);
            VerifyIngest.verifyIngest(c, params);
            while (c.tableOperations().listSplits(table).size() < 10) {
                UtilWaitThread.sleepUninterruptibly((long)15L, (TimeUnit)TimeUnit.SECONDS);
            }
            TableId id = TableId.of((String)((String)c.tableOperations().tableIdMap().get(table)));
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                KeyExtent extent = new KeyExtent(id, null, null);
                s.setRange(extent.toMetadataRange());
                MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)s);
                int count = 0;
                int shortened = 0;
                for (Map.Entry entry : s) {
                    extent = new KeyExtent(((Key)entry.getKey()).getRow(), (Value)entry.getValue());
                    if (extent.getEndRow() != null && extent.getEndRow().toString().length() < 14) {
                        ++shortened;
                    }
                    ++count;
                }
                Assert.assertTrue((String)("Shortened should be greater than zero: " + shortened), (shortened > 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Count should be cgreater than 10: " + count), (count > 10 ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)0L, (long)SplitIT.getCluster().getClusterControl().exec(CheckForMetadataProblems.class, new String[]{"-c", cluster.getClientPropsPath()}));
        }
    }

    @Test
    public void interleaveSplit() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
            props.put(Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none");
            c.tableOperations().create(tableName, new NewTableConfiguration().setProperties(props));
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            ReadWriteIT.interleaveTest(c, tableName);
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            int numSplits = c.tableOperations().listSplits(tableName).size();
            while (numSplits <= 20) {
                log.info("Waiting for splits to happen");
                Thread.sleep(2000L);
                numSplits = c.tableOperations().listSplits(tableName).size();
            }
            Assert.assertTrue((String)("Expected at least 20 splits, saw " + numSplits), (numSplits > 20 ? 1 : 0) != 0);
        }
    }

    @Test
    public void deleteSplit() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName, new NewTableConfiguration().setProperties(Collections.singletonMap(Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K")));
            DeleteIT.deleteTest(c, SplitIT.getCluster(), tableName);
            c.tableOperations().flush(tableName, null, null, true);
            for (int i = 0; i < 5; ++i) {
                UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
                if (c.tableOperations().listSplits(tableName).size() > 20) break;
            }
            Assert.assertTrue((c.tableOperations().listSplits(tableName).size() > 20 ? 1 : 0) != 0);
        }
    }
}

