/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.AuthsIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanIteratorIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ScanIteratorIT.class);
    private AccumuloClient accumuloClient;
    private String tableName;
    private String user;
    private boolean saslEnabled;

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Before
    public void setup() throws Exception {
        PasswordToken userToken;
        this.accumuloClient = (AccumuloClient)Accumulo.newClient().from(ScanIteratorIT.getClientProps()).build();
        this.tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(this.tableName);
        ClusterUser clusterUser = this.getUser(0);
        this.user = clusterUser.getPrincipal();
        if (ScanIteratorIT.saslEnabled()) {
            userToken = null;
            this.saslEnabled = true;
        } else {
            userToken = new PasswordToken((CharSequence)clusterUser.getPassword());
            this.saslEnabled = false;
        }
        if (this.accumuloClient.securityOperations().listLocalUsers().contains(this.user)) {
            log.info("Dropping {}", (Object)this.user);
            this.accumuloClient.securityOperations().dropLocalUser(this.user);
        }
        this.accumuloClient.securityOperations().createLocalUser(this.user, userToken);
        this.accumuloClient.securityOperations().grantTablePermission(this.user, this.tableName, TablePermission.READ);
        this.accumuloClient.securityOperations().grantTablePermission(this.user, this.tableName, TablePermission.WRITE);
        this.accumuloClient.securityOperations().changeUserAuthorizations(this.user, AuthsIterator.AUTHS);
    }

    @After
    public void tearDown() throws Exception {
        if (this.user != null) {
            if (this.saslEnabled) {
                ClusterUser rootUser = this.getAdminUser();
                UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
            }
            this.accumuloClient.securityOperations().dropLocalUser(this.user);
            this.accumuloClient.close();
        }
    }

    @Test
    public void run() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ScanIteratorIT.getClientProps()).build();){
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < 1000; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%06d", i)));
                    m.put(new Text("cf1"), new Text("cq1"), new Value(Integer.toString(1000 - i).getBytes(StandardCharsets.UTF_8)));
                    m.put(new Text("cf1"), new Text("cq2"), new Value(Integer.toString(i - 1000).getBytes(StandardCharsets.UTF_8)));
                    bw.addMutation(m);
                }
            }
            try (Scanner scanner = c.createScanner(tableName);
                 BatchScanner bscanner = c.createBatchScanner(tableName);){
                this.setupIter((ScannerBase)scanner);
                this.verify((Iterable<Map.Entry<Key, Value>>)scanner, 1, 999);
                bscanner.setRanges(Collections.singleton(new Range((Key)null, null)));
                this.setupIter((ScannerBase)bscanner);
                this.verify((Iterable<Map.Entry<Key, Value>>)bscanner, 1, 999);
                ArrayList<Range> ranges = new ArrayList<Range>();
                ranges.add(new Range(new Text(String.format("%06d", 1))));
                ranges.add(new Range(new Text(String.format("%06d", 6)), new Text(String.format("%06d", 16))));
                ranges.add(new Range(new Text(String.format("%06d", 20))));
                ranges.add(new Range(new Text(String.format("%06d", 23))));
                ranges.add(new Range(new Text(String.format("%06d", 56)), new Text(String.format("%06d", 61))));
                ranges.add(new Range(new Text(String.format("%06d", 501)), new Text(String.format("%06d", 504))));
                ranges.add(new Range(new Text(String.format("%06d", 998)), new Text(String.format("%06d", 1000))));
                HashSet<Integer> got = new HashSet<Integer>();
                HashSet<Integer> expected = new HashSet<Integer>();
                for (int i : new int[]{1, 7, 9, 11, 13, 15, 23, 57, 59, 61, 501, 503, 999}) {
                    expected.add(i);
                }
                bscanner.setRanges(ranges);
                Object object = bscanner.iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    got.add(Integer.parseInt(((Key)entry.getKey()).getRow().toString()));
                }
                System.out.println("got : " + got);
                if (!got.equals(expected)) {
                    throw new Exception(got + " != " + expected);
                }
            }
        }
    }

    private void verify(Iterable<Map.Entry<Key, Value>> scanner, int start, int finish) throws Exception {
        int expected = start;
        for (Map.Entry<Key, Value> entry : scanner) {
            if (Integer.parseInt(entry.getKey().getRow().toString()) != expected) {
                throw new Exception("Saw unexpexted " + entry.getKey().getRow() + " " + expected);
            }
            if (!entry.getKey().getColumnQualifier().toString().equals("cq2")) continue;
            expected += 2;
        }
        if (expected != finish + 2) {
            throw new Exception("Ended at " + expected + " not " + (finish + 2));
        }
    }

    private void setupIter(ScannerBase scanner) {
        IteratorSetting dropMod = new IteratorSetting(50, "dropMod", "org.apache.accumulo.test.functional.DropModIter");
        dropMod.addOption("mod", "2");
        dropMod.addOption("drop", "0");
        scanner.addScanIterator(dropMod);
    }

    @Test
    public void testAuthsPresentInIteratorEnvironment() throws Exception {
        this.runTest(AuthsIterator.AUTHS, false);
    }

    @Test
    public void testAuthsNotPresentInIteratorEnvironment() throws Exception {
        this.runTest(new Authorizations(new String[]{"B"}), true);
    }

    @Test
    public void testEmptyAuthsInIteratorEnvironment() throws Exception {
        this.runTest(Authorizations.EMPTY, true);
    }

    private void runTest(ScannerBase scanner, boolean shouldFail) {
        int count = 0;
        for (Map.Entry entry : scanner) {
            Assert.assertEquals((Object)(shouldFail ? "FAIL" : "SUCCESS"), (Object)((Key)entry.getKey()).getRow().toString());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    private void runTest(Authorizations auths, boolean shouldFail) throws Exception {
        ClusterUser clusterUser = this.getUser(0);
        AccumuloClient userC = ScanIteratorIT.getCluster().createAccumuloClient(clusterUser.getPrincipal(), clusterUser.getToken());
        this.writeTestMutation(userC);
        IteratorSetting setting = new IteratorSetting(10, AuthsIterator.class);
        try (Scanner scanner = userC.createScanner(this.tableName, auths);
             BatchScanner batchScanner = userC.createBatchScanner(this.tableName, auths, 1);){
            scanner.addScanIterator(setting);
            batchScanner.setRanges(Collections.singleton(new Range((CharSequence)"1")));
            batchScanner.addScanIterator(setting);
            this.runTest((ScannerBase)scanner, shouldFail);
            this.runTest((ScannerBase)batchScanner, shouldFail);
        }
    }

    private void writeTestMutation(AccumuloClient userC) throws TableNotFoundException, MutationsRejectedException {
        try (BatchWriter batchWriter = userC.createBatchWriter(this.tableName);){
            Mutation m = new Mutation((CharSequence)"1");
            m.put(new Text("2"), new Text("3"), new Value("".getBytes()));
            batchWriter.addMutation(m);
            batchWriter.flush();
        }
    }
}

