/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.junit.Assert;
import org.junit.Test;

public class MasterAssignmentIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MasterAssignmentIT.getClientProps()).build();){
            TabletLocationState newTablet;
            String tableName = super.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
            do {
                UtilWaitThread.sleep((long)250L);
                newTablet = this.getTabletLocationState(c, tableId);
            } while (newTablet.current == null);
            Assert.assertNull((Object)newTablet.last);
            Assert.assertNull((Object)newTablet.future);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"a");
                m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
                bw.addMutation(m);
            }
            c.tableOperations().flush(tableName, null, null, true);
            TabletLocationState flushed = this.getTabletLocationState(c, tableId);
            Assert.assertEquals((Object)newTablet.current, (Object)flushed.current);
            Assert.assertEquals((Object)flushed.current, (Object)flushed.last);
            Assert.assertNull((Object)newTablet.future);
            c.tableOperations().offline(tableName, true);
            TabletLocationState offline = this.getTabletLocationState(c, tableId);
            Assert.assertNull((Object)offline.future);
            Assert.assertNull((Object)offline.current);
            Assert.assertEquals((Object)flushed.current, (Object)offline.last);
            c.tableOperations().online(tableName, true);
            TabletLocationState online = this.getTabletLocationState(c, tableId);
            Assert.assertNull((Object)online.future);
            Assert.assertNotNull((Object)online.current);
            Assert.assertEquals((Object)online.current, (Object)online.last);
        }
    }

    private TabletLocationState getTabletLocationState(AccumuloClient c, String tableId) {
        try (MetaDataTableScanner s = new MetaDataTableScanner((ClientContext)c, new Range(MetadataSchema.TabletsSection.getRow((TableId)TableId.of((String)tableId), null)));){
            TabletLocationState tabletLocationState = s.next();
            return tabletLocationState;
        }
    }
}

