/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.zookeeper.ZooReaderWriterFactory;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FateConcurrencyIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(FateConcurrencyIT.class);
    private static final int NUM_ROWS = 1000;
    private static final long SLOW_SCAN_SLEEP_MS = 250L;
    private AccumuloClient accumuloClient;
    private ClientContext context;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private String tableName;
    private String secret;
    private boolean runMultipleCompactions = false;

    @Before
    public void setup() {
        this.accumuloClient = (AccumuloClient)Accumulo.newClient().from(FateConcurrencyIT.getClientProps()).build();
        this.context = (ClientContext)this.accumuloClient;
        this.tableName = this.getUniqueNames(1)[0];
        this.secret = cluster.getSiteConfiguration().get(Property.INSTANCE_SECRET);
        this.createData(this.tableName);
    }

    @After
    public void closeClient() {
        this.accumuloClient.close();
    }

    @AfterClass
    public static void cleanup() {
        pool.shutdownNow();
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void changeTableStateTest() throws Exception {
        Assert.assertEquals((String)"verify table online after created", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
        OnLineCallable onlineOp = new OnLineCallable(this.tableName);
        Future<OnlineOpTiming> task = pool.submit(onlineOp);
        OnlineOpTiming timing1 = task.get();
        log.trace("Online 1 in {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing1.runningTime(), TimeUnit.NANOSECONDS));
        Assert.assertEquals((String)"verify table is still online", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
        this.accumuloClient.tableOperations().offline(this.tableName, true);
        Assert.assertEquals((String)"verify table is offline", (Object)TableState.OFFLINE, (Object)this.getTableState(this.tableName));
        onlineOp = new OnLineCallable(this.tableName);
        task = pool.submit(onlineOp);
        OnlineOpTiming timing2 = task.get();
        log.trace("Online 2 in {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing2.runningTime(), TimeUnit.NANOSECONDS));
        Assert.assertEquals((String)"verify table is back online", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
        Future<?> compactTask = this.startCompactTask();
        onlineOp = new OnLineCallable(this.tableName);
        task = pool.submit(onlineOp);
        OnlineOpTiming timing3 = task.get();
        Assert.assertTrue((String)"online should take less time than expected compaction time", (timing3.runningTime() < TimeUnit.NANOSECONDS.convert(250000L, TimeUnit.MILLISECONDS) ? 1 : 0) != 0);
        Assert.assertEquals((String)"verify table is still online", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
        Assert.assertTrue((String)"verify compaction still running and fate transaction still exists", (boolean)this.blockUntilCompactionRunning(this.tableName));
        this.accumuloClient.tableOperations().cancelCompaction(this.tableName);
        log.debug("Success: Timing results for online commands.");
        log.debug("Time for unblocked online {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing1.runningTime(), TimeUnit.NANOSECONDS));
        log.debug("Time for online when offline {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing2.runningTime(), TimeUnit.NANOSECONDS));
        log.debug("Time for blocked online {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing3.runningTime(), TimeUnit.NANOSECONDS));
        compactTask.get();
    }

    @Test
    public void getFateStatus() {
        TableId tableId;
        if (this.runMultipleCompactions) {
            this.runMultipleCompactions();
        }
        try {
            Assert.assertEquals((String)"verify table online after created", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
            tableId = Tables.getTableId((ClientContext)this.context, (String)this.tableName);
            log.trace("tid: {}", (Object)tableId);
        }
        catch (TableNotFoundException ex) {
            throw new IllegalStateException(String.format("Table %s does not exist, failing test", this.tableName));
        }
        Future<?> compactTask = this.startCompactTask();
        AdminUtil.FateStatus withLocks = null;
        List noLocks = null;
        AdminUtil admin = new AdminUtil(false);
        for (int maxRetries = 3; maxRetries > 0; --maxRetries) {
            try {
                String instanceId = this.accumuloClient.instanceOperations().getInstanceID();
                ClientInfo info = ClientInfo.from((Properties)this.accumuloClient.properties());
                IZooReaderWriter zk = new ZooReaderWriterFactory().getZooReaderWriter(info.getZooKeepers(), info.getZooKeepersSessionTimeOut(), this.secret);
                ZooStore zs = new ZooStore(ZooUtil.getRoot((String)instanceId) + "/fate", zk);
                withLocks = admin.getStatus((ReadOnlyTStore)zs, (IZooReader)zk, ZooUtil.getRoot((String)instanceId) + "/table_locks" + "/" + tableId, null, null);
                noLocks = admin.getTransactionStatus((ReadOnlyTStore)zs, null, null);
                break;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                Assert.fail((String)"Interrupt received - test failed");
                return;
            }
            catch (KeeperException ex) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException intr_ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
        Assert.assertNotNull(withLocks);
        Assert.assertNotNull(noLocks);
        Assert.assertEquals((long)withLocks.getTransactions().size(), (long)noLocks.size());
        int matchCount = 0;
        for (AdminUtil.TransactionStatus tx : withLocks.getTransactions()) {
            if (!this.isCompaction(tx)) continue;
            log.trace("Fate id: {}, status: {}", (Object)tx.getTxid(), (Object)tx.getStatus());
            for (AdminUtil.TransactionStatus tx2 : noLocks) {
                if (!tx2.getTxid().equals(tx.getTxid())) continue;
                ++matchCount;
            }
        }
        Assert.assertTrue((String)"Number of fates matches should be > 0", (matchCount > 0 ? 1 : 0) != 0);
        try {
            this.accumuloClient.tableOperations().cancelCompaction(this.tableName);
            compactTask.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | AccumuloException | AccumuloSecurityException | TableNotFoundException ex) {
            log.debug("Could not cancel compaction", ex);
        }
    }

    private void runMultipleCompactions() {
        for (int i = 0; i < 4; ++i) {
            String aTableName = this.getUniqueNames(1)[0] + "_" + i;
            this.createData(aTableName);
            log.debug("Table: {}", (Object)aTableName);
            pool.submit(new SlowCompactionRunner(aTableName));
            Assert.assertTrue((String)"verify that compaction running and fate transaction exists", (boolean)this.blockUntilCompactionRunning(aTableName));
        }
    }

    private Future<?> startCompactTask() {
        Future<?> compactTask = pool.submit(new SlowCompactionRunner(this.tableName));
        Assert.assertTrue((String)"verify that compaction running and fate transaction exists", (boolean)this.blockUntilCompactionRunning(this.tableName));
        return compactTask;
    }

    private boolean blockUntilCompactionRunning(String tableName) {
        long maxWait = this.defaultTimeoutSeconds() <= 0 ? 60000L : (long)(this.defaultTimeoutSeconds() * 1000 / 2);
        long startWait = System.currentTimeMillis();
        List tservers = this.accumuloClient.instanceOperations().getTabletServers();
        while (System.currentTimeMillis() < startWait + maxWait) {
            try {
                int runningCompactions = 0;
                for (String tserver : tservers) {
                    log.trace("tserver {}, running compactions {}", (Object)tservers, (Object)(runningCompactions += this.accumuloClient.instanceOperations().getActiveCompactions(tserver).size()));
                }
                if (runningCompactions > 0 && this.findFate(tableName)) {
                    return true;
                }
            }
            catch (AccumuloException | AccumuloSecurityException ex) {
                throw new IllegalStateException("failed to get active compactions, test fails.", ex);
            }
            catch (KeeperException ex) {
                log.trace("Saw possible transient zookeeper error");
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        log.debug("Could not find compaction for {} after {} seconds", (Object)tableName, (Object)TimeUnit.MILLISECONDS.toSeconds(maxWait));
        return false;
    }

    private boolean findFate(String tableName) throws KeeperException {
        AdminUtil admin = new AdminUtil(false);
        try {
            TableId tableId = Tables.getTableId((ClientContext)this.context, (String)tableName);
            log.trace("tid: {}", (Object)tableId);
            ClientInfo info = ClientInfo.from((Properties)this.accumuloClient.properties());
            IZooReaderWriter zk = new ZooReaderWriterFactory().getZooReaderWriter(info.getZooKeepers(), info.getZooKeepersSessionTimeOut(), this.secret);
            ZooStore zs = new ZooStore(ZooUtil.getRoot((String)this.accumuloClient.instanceOperations().getInstanceID()) + "/fate", zk);
            AdminUtil.FateStatus fateStatus = admin.getStatus((ReadOnlyTStore)zs, (IZooReader)zk, ZooUtil.getRoot((String)this.accumuloClient.instanceOperations().getInstanceID()) + "/table_locks" + "/" + tableId, null, null);
            log.trace("current fates: {}", (Object)fateStatus.getTransactions().size());
            for (AdminUtil.TransactionStatus tx : fateStatus.getTransactions()) {
                if (!this.isCompaction(tx)) continue;
                return true;
            }
        }
        catch (InterruptedException | TableNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        return Boolean.FALSE;
    }

    private boolean isCompaction(AdminUtil.TransactionStatus tx) {
        if (tx == null) {
            log.trace("Fate tx is null");
            return false;
        }
        log.trace("Fate id: {}, status: {}", (Object)tx.getTxid(), (Object)tx.getStatus());
        String top = tx.getTop();
        String debug = tx.getDebug();
        return top != null && debug != null && top.contains("CompactionDriver") && tx.getDebug().contains("CompactRange");
    }

    private TableState getTableState(String tableName) throws TableNotFoundException {
        TableId tableId = Tables.getTableId((ClientContext)this.context, (String)tableName);
        TableState tstate = Tables.getTableState((ClientContext)this.context, (TableId)tableId);
        log.trace("tableName: '{}': tableId {}, current state: {}", new Object[]{tableName, tableId, tstate});
        return tstate;
    }

    private void createData(String tableName) {
        try {
            this.accumuloClient.tableOperations().create(tableName);
            try (BatchWriter bw = this.accumuloClient.createBatchWriter(tableName);){
                for (int i = 0; i < 1000; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%05d", i)));
                    m.put(new Text("col" + (i % 3 + 1)), new Text("qual"), new Value("junk".getBytes(StandardCharsets.UTF_8)));
                    bw.addMutation(m);
                }
            }
            long startTimestamp = System.nanoTime();
            int count = this.scanCount(tableName);
            log.trace("Scan time for {} rows {} ms", (Object)1000, (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimestamp, TimeUnit.NANOSECONDS));
            if (count != 1000) {
                throw new IllegalStateException(String.format("Number of rows %1$d does not match expected %2$d", count, 1000));
            }
        }
        catch (AccumuloException | AccumuloSecurityException | TableExistsException | TableNotFoundException ex) {
            throw new IllegalStateException("Create data failed with exception", ex);
        }
    }

    private int scanCount(String tableName) throws TableNotFoundException {
        int count = 0;
        try (Scanner scanner = this.accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            for (Map.Entry elt : scanner) {
                String expected = String.format("%05d", count);
                assert (((Key)elt.getKey()).getRow().toString().equals(expected));
                ++count;
            }
        }
        return count;
    }

    private class SlowCompactionRunner
    implements Runnable {
        private final String tableName;

        SlowCompactionRunner(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public void run() {
            block5: {
                long startTimestamp = System.nanoTime();
                IteratorSetting slow = new IteratorSetting(30, "slow", SlowIterator.class);
                SlowIterator.setSleepTime(slow, 250L);
                ArrayList<IteratorSetting> compactIterators = new ArrayList<IteratorSetting>();
                compactIterators.add(slow);
                log.trace("Slow iterator {}", (Object)slow);
                try {
                    log.trace("Start compaction");
                    FateConcurrencyIT.this.accumuloClient.tableOperations().compact(this.tableName, new Text("0"), new Text("z"), compactIterators, true, true);
                    log.trace("Compaction wait is complete");
                    log.trace("Slow compaction of {} rows took {} ms", (Object)1000, (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimestamp, TimeUnit.NANOSECONDS));
                    startTimestamp = System.nanoTime();
                    int count = FateConcurrencyIT.this.scanCount(this.tableName);
                    log.trace("After compaction, scan time for {} rows {} ms", (Object)1000, (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimestamp, TimeUnit.NANOSECONDS));
                    if (count != 1000) {
                        throw new IllegalStateException(String.format("After compaction, number of rows %1$d does not match expected %2$d", count, 1000));
                    }
                }
                catch (TableNotFoundException ex) {
                    throw new IllegalStateException("test failed, table " + this.tableName + " does not exist", ex);
                }
                catch (AccumuloSecurityException ex) {
                    throw new IllegalStateException("test failed, could not add iterator due to security exception", ex);
                }
                catch (AccumuloException ex) {
                    if (ex.getMessage().contains("Compaction canceled")) break block5;
                    throw new IllegalStateException("test failed with an Accumulo exception", ex);
                }
            }
        }
    }

    private class OnLineCallable
    implements Callable<OnlineOpTiming> {
        final String tableName;

        OnLineCallable(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public OnlineOpTiming call() throws Exception {
            OnlineOpTiming status = new OnlineOpTiming();
            log.trace("Setting {} online", (Object)this.tableName);
            FateConcurrencyIT.this.accumuloClient.tableOperations().online(this.tableName, true);
            status.setComplete();
            log.trace("Online completed in {} ms", (Object)TimeUnit.MILLISECONDS.convert(status.runningTime(), TimeUnit.NANOSECONDS));
            return status;
        }
    }

    private static class OnlineOpTiming {
        private final long started = System.nanoTime();
        private long completed = 0L;

        OnlineOpTiming() {
        }

        void setComplete() {
            this.completed = System.nanoTime();
        }

        long runningTime() {
            return this.completed - this.started;
        }
    }
}

