/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRowsSplitIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(DeleteRowsSplitIT.class);
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxyz";
    static final SortedSet<Text> SPLITS = new TreeSet<Text>();
    static final List<String> ROWS = new ArrayList<String>();

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Test
    public void run() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(DeleteRowsSplitIT.getClientProps()).build();){
            int test = 0;
            while (test < 10) {
                log.info("Test {}", (Object)test);
                client.tableOperations().create(tableName);
                this.fillTable(client, tableName);
                Text start = new Text();
                Text end = new Text();
                this.generateRandomRange(start, end);
                boolean[] fail = new boolean[]{false};
                Thread t = new Thread(() -> {
                    try {
                        SortedSet<Text> afterEnd = SPLITS.tailSet(new Text(end + "\u0000"));
                        client.tableOperations().addSplits(tableName, afterEnd);
                        return;
                    }
                    catch (Exception ex) {
                        log.error("Exception", (Throwable)ex);
                        boolean[] blArray = fail;
                        synchronized (fail) {
                            fail[0] = true;
                            // ** MonitorExit[var5_6] (shouldn't be in output)
                            return;
                        }
                    }
                });
                t.start();
                UtilWaitThread.sleepUninterruptibly((long)(test * 2), (TimeUnit)TimeUnit.MILLISECONDS);
                client.tableOperations().deleteRows(tableName, start, end);
                t.join();
                boolean[] blArray = fail;
                // MONITORENTER : fail
                Assert.assertTrue((!fail[0] ? 1 : 0) != 0);
                // MONITOREXIT : blArray
                try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                    for (Map.Entry entry : scanner) {
                        Text row = ((Key)entry.getKey()).getRow();
                        Assert.assertTrue((row.compareTo((BinaryComparable)start) <= 0 || row.compareTo((BinaryComparable)end) > 0 ? 1 : 0) != 0);
                    }
                    client.tableOperations().delete(tableName);
                }
                ++test;
            }
            return;
        }
    }

    private void generateRandomRange(Text start, Text end) {
        ArrayList<String> bunch = new ArrayList<String>(ROWS);
        Collections.shuffle(bunch);
        if (((String)bunch.get(0)).compareTo((String)bunch.get(1)) < 0) {
            start.set((String)bunch.get(0));
            end.set((String)bunch.get(1));
        } else {
            start.set((String)bunch.get(1));
            end.set((String)bunch.get(0));
        }
    }

    private void fillTable(AccumuloClient client, String table) throws Exception {
        try (BatchWriter bw = client.createBatchWriter(table);){
            for (String row : ROWS) {
                Mutation m = new Mutation((CharSequence)row);
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
        }
    }

    static {
        for (byte b : LETTERS.getBytes(StandardCharsets.UTF_8)) {
            SPLITS.add(new Text(new byte[]{b}));
            ROWS.add(new String(new byte[]{b}, StandardCharsets.UTF_8));
        }
    }
}

