/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Iterator;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CredentialsIT
extends AccumuloClusterHarness {
    private boolean saslEnabled;
    private String username;
    private String password;

    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Before
    public void createLocalUser() throws AccumuloException, AccumuloSecurityException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CredentialsIT.getClientProps()).build();){
            ClusterUser user = this.getUser(0);
            this.username = user.getPrincipal();
            this.saslEnabled = CredentialsIT.saslEnabled();
            Set users = client.securityOperations().listLocalUsers();
            if (!users.contains(this.username)) {
                PasswordToken passwdToken = null;
                if (!this.saslEnabled) {
                    this.password = user.getPassword();
                    passwdToken = new PasswordToken((CharSequence)this.password);
                }
                client.securityOperations().createLocalUser(this.username, passwdToken);
            }
        }
    }

    @After
    public void deleteLocalUser() throws Exception {
        if (this.saslEnabled) {
            ClusterUser root = this.getAdminUser();
            UserGroupInformation.loginUserFromKeytab((String)root.getPrincipal(), (String)root.getKeytab().getAbsolutePath());
        }
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CredentialsIT.getClientProps()).build();){
            client.securityOperations().dropLocalUser(this.username);
        }
    }

    @Test
    public void testConnectorWithDestroyedToken() throws Exception {
        AuthenticationToken token = this.getUser(0).getToken();
        Assert.assertFalse((boolean)token.isDestroyed());
        token.destroy();
        Assert.assertTrue((boolean)token.isDestroyed());
        try (AccumuloClient ignored = (AccumuloClient)Accumulo.newClient().from(CredentialsIT.getClientInfo().getProperties()).as((CharSequence)"non_existent_user", token).build();){
            Assert.fail((String)("should ignore " + ignored));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"AuthenticationToken has been destroyed");
        }
    }

    @Test
    public void testDestroyTokenBeforeRPC() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CredentialsIT.getClientProps()).build();){
            AuthenticationToken token = this.getUser(0).getToken();
            try (AccumuloClient userAccumuloClient = (AccumuloClient)Accumulo.newClient().from(client.properties()).as((CharSequence)this.username, token).build();
                 Scanner scanner = userAccumuloClient.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                Assert.assertFalse((boolean)token.isDestroyed());
                token.destroy();
                Assert.assertTrue((boolean)token.isDestroyed());
                try {
                    Iterator iter = scanner.iterator();
                    while (iter.hasNext()) {
                        Assert.fail();
                    }
                    Assert.fail();
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof RuntimeException));
                    Assert.assertTrue((boolean)(e.getCause() instanceof AccumuloSecurityException));
                    Assert.assertEquals((Object)((AccumuloSecurityException)((Object)AccumuloSecurityException.class.cast(e.getCause()))).getSecurityErrorCode(), (Object)SecurityErrorCode.TOKEN_EXPIRED);
                }
            }
        }
    }
}

