/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Base64;
import java.util.Collection;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateInitialSplitsIT
extends AccumuloClusterHarness {
    private AccumuloClient client;
    private String tableName;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration conf) {
        cfg.setMemory(ServerType.TABLET_SERVER, 512L, MemoryUnit.MEGABYTE);
        conf.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Before
    public void setupInitialSplits() {
        this.client = (AccumuloClient)Accumulo.newClient().from(CreateInitialSplitsIT.getClientProps()).build();
    }

    @After
    public void closeClient() {
        this.client.close();
    }

    @Test
    public void testCreateTableWithNoSplits() throws TableExistsException, AccumuloSecurityException, AccumuloException {
        this.tableName = this.getUniqueNames(1)[0];
        this.client.tableOperations().create(this.tableName);
        Assert.assertTrue((boolean)this.client.tableOperations().exists(this.tableName));
    }

    private void runTest(SortedSet<Text> expectedSplits) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        NewTableConfiguration ntc = new NewTableConfiguration().withSplits(expectedSplits);
        Assert.assertFalse((boolean)this.client.tableOperations().exists(this.tableName));
        this.client.tableOperations().create(this.tableName, ntc);
        Assert.assertTrue((boolean)this.client.tableOperations().exists(this.tableName));
        Collection createdSplits = this.client.tableOperations().listSplits(this.tableName);
        Assert.assertEquals(expectedSplits, new TreeSet(createdSplits));
    }

    @Test
    public void testCreateInitialSplits() throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.tableName = this.getUniqueNames(1)[0];
        this.runTest(this.generateNonBinarySplits(3000, 32));
    }

    @Test
    public void testCreateInitialSplitsWithEncodedSplits() throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.tableName = this.getUniqueNames(1)[0];
        this.runTest(this.generateNonBinarySplits(3000, 32, true));
    }

    @Test
    public void testCreateInitialBinarySplits() throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.tableName = this.getUniqueNames(1)[0];
        this.runTest(this.generateBinarySplits(1000, 16));
    }

    @Test
    public void testCreateInitialBinarySplitsWithEncodedSplits() throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.tableName = this.getUniqueNames(1)[0];
        this.runTest(this.generateBinarySplits(1000, 16, true));
    }

    @Test
    public void testCreateInitialSplitsCopiedFromAnotherTable() throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.tableName = this.getUniqueNames(1)[0];
        NewTableConfiguration ntc = new NewTableConfiguration();
        this.client.tableOperations().create(this.tableName, ntc);
        Assert.assertTrue((boolean)this.client.tableOperations().exists(this.tableName));
        TreeSet<Text> splits = new TreeSet<Text>();
        splits.add(new Text("ccccc"));
        splits.add(new Text("mmmmm"));
        splits.add(new Text("ttttt"));
        this.client.tableOperations().addSplits(this.tableName, splits);
        Collection otherSplits = this.client.tableOperations().listSplits(this.tableName);
        Assert.assertEquals(splits, new TreeSet(otherSplits));
        String tableName2 = this.getUniqueNames(2)[1];
        NewTableConfiguration ntc2 = new NewTableConfiguration();
        ntc2.withSplits(new TreeSet(otherSplits));
        Assert.assertFalse((boolean)this.client.tableOperations().exists(tableName2));
        this.client.tableOperations().create(tableName2, ntc);
        Assert.assertTrue((boolean)this.client.tableOperations().exists(tableName2));
        Collection createdSplits = this.client.tableOperations().listSplits(this.tableName);
        Assert.assertEquals(splits, new TreeSet(createdSplits));
    }

    @Test
    public void testMultipleOperationsFunctionality() throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.tableName = this.getUniqueNames(1)[0];
        SortedSet<Text> expectedSplits = this.generateNonBinarySplits(1000, 32);
        this.runTest(expectedSplits);
        this.client.tableOperations().flush(this.tableName);
        this.client.tableOperations().compact(this.tableName, null, null, true, true);
        Collection createdSplits = this.client.tableOperations().listSplits(this.tableName);
        Assert.assertEquals(expectedSplits, new TreeSet(createdSplits));
        this.client.tableOperations().delete(this.tableName);
        Assert.assertFalse((boolean)this.client.tableOperations().exists(this.tableName));
    }

    private SortedSet<Text> generateNonBinarySplits(int numItems, int len) {
        return this.generateNonBinarySplits(numItems, len, false);
    }

    private SortedSet<Text> generateNonBinarySplits(int numItems, int len, boolean useB64) {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < numItems; ++i) {
            splits.add(this.encode(this.getRandomText(len), useB64));
        }
        return splits;
    }

    private SortedSet<Text> generateBinarySplits(int numItems, int len) {
        return this.generateBinarySplits(numItems, len, false);
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="predictable random is okay for testing")
    private SortedSet<Text> generateBinarySplits(int numItems, int len, boolean useB64) {
        TreeSet<Text> splits = new TreeSet<Text>();
        Random rand = new Random();
        for (int i = 0; i < numItems; ++i) {
            byte[] split = new byte[len];
            rand.nextBytes(split);
            splits.add(this.encode(new Text(split), useB64));
        }
        return splits;
    }

    private Text encode(Text text, boolean encode) {
        if (text == null) {
            return null;
        }
        return encode ? new Text(Base64.getEncoder().encodeToString(TextUtil.getBytes((Text)text))) : text;
    }

    private Text getRandomText(int len) {
        int desiredLen = len;
        if (len > 32) {
            desiredLen = 32;
        }
        return new Text(String.valueOf(UUID.randomUUID()).replaceAll("-", "").substring(0, desiredLen - 1));
    }
}

