/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.constraints.AlphaNumKeyConstraint;
import org.apache.accumulo.test.constraints.NumericValueConstraint;
import org.apache.hadoop.io.Text;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ConstraintIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void run() throws Exception {
        String[] tableNames = this.getUniqueNames(3);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ConstraintIT.getClientProps()).build();){
            for (String table : tableNames) {
                c.tableOperations().create(table);
                c.tableOperations().addConstraint(table, NumericValueConstraint.class.getName());
                c.tableOperations().addConstraint(table, AlphaNumKeyConstraint.class.getName());
            }
            Thread.sleep(10000L);
            for (String table : tableNames) {
                log.debug("Checking constraints on {}", (Object)table);
                Map constraints = c.tableOperations().listConstraints(table);
                while (!constraints.containsKey(NumericValueConstraint.class.getName()) || !constraints.containsKey(AlphaNumKeyConstraint.class.getName())) {
                    log.debug("Failed to verify constraints. Sleeping and retrying");
                    Thread.sleep(2000L);
                    constraints = c.tableOperations().listConstraints(table);
                }
                log.debug("Verified all constraints on {}", (Object)table);
            }
            log.debug("Verified constraints on all tables. Running tests");
            this.test1(c, tableNames[0]);
            this.test2(c, tableNames[1], false);
            this.test2(c, tableNames[2], true);
        }
    }

    private void test1(AccumuloClient client, String tableName) throws Exception {
        BatchWriter bw = client.createBatchWriter(tableName);
        Mutation mut1 = new Mutation(new Text("r1"));
        mut1.put(new Text("cf1"), new Text("cq1"), new Value("123".getBytes(StandardCharsets.UTF_8)));
        bw.addMutation(mut1);
        bw.close();
        bw = client.createBatchWriter(tableName);
        Mutation mut2 = new Mutation(new Text("r1"));
        mut2.put(new Text("cf1"), new Text("cq1"), new Value("123a".getBytes(StandardCharsets.UTF_8)));
        bw.addMutation(mut2);
        boolean sawMRE = false;
        try {
            bw.close();
            throw new Exception("Test failed, constraint did not catch bad mutation");
        }
        catch (MutationsRejectedException mre) {
            sawMRE = true;
            List cvsl = mre.getConstraintViolationSummaries();
            if (cvsl.size() != 1) {
                throw new Exception("Unexpected constraints");
            }
            for (ConstraintViolationSummary cvs : cvsl) {
                if (!cvs.constrainClass.equals(NumericValueConstraint.class.getName())) {
                    throw new Exception("Unexpected constraint class " + cvs.constrainClass);
                }
                if (cvs.numberOfViolatingMutations == 1L) continue;
                throw new Exception("Unexpected # violating mutations " + cvs.numberOfViolatingMutations);
            }
            if (!sawMRE) {
                throw new Exception("Did not see MutationsRejectedException");
            }
            Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);
            try {
                scanner.setRange(new Range(new Text("r1")));
                Iterator iter = scanner.iterator();
                Map.Entry entry = (Map.Entry)iter.next();
                if (!(((Key)entry.getKey()).getRow().equals((Object)new Text("r1")) && ((Key)entry.getKey()).getColumnFamily().equals((Object)new Text("cf1")) && ((Key)entry.getKey()).getColumnQualifier().equals((Object)new Text("cq1")) && ((Value)entry.getValue()).equals((Object)new Value("123".getBytes(StandardCharsets.UTF_8))))) {
                    throw new Exception("Unexpected key or value " + entry.getKey() + " " + entry.getValue());
                }
                if (iter.hasNext()) {
                    entry = (Map.Entry)iter.next();
                    throw new Exception("Unexpected extra key or value " + entry.getKey() + " " + entry.getValue());
                }
                client.tableOperations().removeConstraint(tableName, 2);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                bw = client.createBatchWriter(tableName);
                bw.addMutation(mut2);
                bw.close();
                iter = scanner.iterator();
                entry = (Map.Entry)iter.next();
                if (!(((Key)entry.getKey()).getRow().equals((Object)new Text("r1")) && ((Key)entry.getKey()).getColumnFamily().equals((Object)new Text("cf1")) && ((Key)entry.getKey()).getColumnQualifier().equals((Object)new Text("cq1")) && ((Value)entry.getValue()).equals((Object)new Value("123a".getBytes(StandardCharsets.UTF_8))))) {
                    throw new Exception("Unexpected key or value " + entry.getKey() + " " + entry.getValue());
                }
                if (iter.hasNext()) {
                    entry = (Map.Entry)iter.next();
                    throw new Exception("Unexpected extra key or value " + entry.getKey() + " " + entry.getValue());
                }
                client.tableOperations().setProperty(tableName, Property.TABLE_CONSTRAINT_PREFIX + "1", "com.foobar.nonExistantClass");
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                bw = client.createBatchWriter(tableName);
                Mutation mut3 = new Mutation(new Text("r1"));
                mut3.put(new Text("cf1"), new Text("cq1"), new Value("foo".getBytes(StandardCharsets.UTF_8)));
                bw.addMutation(mut3);
                sawMRE = false;
                try {
                    bw.close();
                    throw new Exception("Test failed, mutation went through when table had bad constraints");
                }
                catch (MutationsRejectedException mre2) {
                    sawMRE = true;
                    if (!sawMRE) {
                        throw new Exception("Did not see MutationsRejectedException");
                    }
                    iter = scanner.iterator();
                    entry = (Map.Entry)iter.next();
                    if (!(((Key)entry.getKey()).getRow().equals((Object)new Text("r1")) && ((Key)entry.getKey()).getColumnFamily().equals((Object)new Text("cf1")) && ((Key)entry.getKey()).getColumnQualifier().equals((Object)new Text("cq1")) && ((Value)entry.getValue()).equals((Object)new Value("123a".getBytes(StandardCharsets.UTF_8))))) {
                        throw new Exception("Unexpected key or value " + entry.getKey() + " " + entry.getValue());
                    }
                    if (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        throw new Exception("Unexpected extra key or value " + entry.getKey() + " " + entry.getValue());
                    }
                    client.tableOperations().removeConstraint(tableName, 1);
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    bw = client.createBatchWriter(tableName);
                    bw.addMutation(mut3);
                    bw.close();
                    iter = scanner.iterator();
                    entry = (Map.Entry)iter.next();
                    if (!(((Key)entry.getKey()).getRow().equals((Object)new Text("r1")) && ((Key)entry.getKey()).getColumnFamily().equals((Object)new Text("cf1")) && ((Key)entry.getKey()).getColumnQualifier().equals((Object)new Text("cq1")) && ((Value)entry.getValue()).equals((Object)new Value("foo".getBytes(StandardCharsets.UTF_8))))) {
                        throw new Exception("Unexpected key or value " + entry.getKey() + " " + entry.getValue());
                    }
                    if (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        throw new Exception("Unexpected extra key or value " + entry.getKey() + " " + entry.getValue());
                    }
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            return;
        }
    }

    private Mutation newMut(String row, String cf, String cq, String val) {
        Mutation mut1 = new Mutation(new Text(row));
        mut1.put(new Text(cf), new Text(cq), new Value(val.getBytes(StandardCharsets.UTF_8)));
        return mut1;
    }

    private void test2(AccumuloClient client, String table, boolean doFlush) throws Exception {
        int numericErrors = 2;
        BatchWriter bw = client.createBatchWriter(table);
        bw.addMutation(this.newMut("r1", "cf1", "cq1", "123"));
        bw.addMutation(this.newMut("r1", "cf1", "cq2", "I'm a bad value"));
        if (doFlush) {
            try {
                bw.flush();
                throw new Exception("Didn't find a bad mutation");
            }
            catch (MutationsRejectedException mre) {
                try {
                    bw.close();
                }
                catch (MutationsRejectedException mutationsRejectedException) {
                    // empty catch block
                }
                bw = client.createBatchWriter(table);
                numericErrors = 1;
            }
        }
        bw.addMutation(this.newMut("r1", "cf1", "cq3", "I'm a naughty value"));
        bw.addMutation(this.newMut("@bad row@", "cf1", "cq2", "456"));
        bw.addMutation(this.newMut("r1", "cf1", "cq4", "789"));
        boolean sawMRE = false;
        try {
            bw.close();
            throw new Exception("Test failed, constraint did not catch bad mutation");
        }
        catch (MutationsRejectedException mre) {
            System.out.println((Object)mre);
            sawMRE = true;
            List cvsl = mre.getConstraintViolationSummaries();
            if (cvsl.size() != 2) {
                throw new Exception("Unexpected constraints");
            }
            HashMap<String, Integer> expected = new HashMap<String, Integer>();
            expected.put("org.apache.accumulo.test.constraints.NumericValueConstraint", numericErrors);
            expected.put("org.apache.accumulo.test.constraints.AlphaNumKeyConstraint", 1);
            for (ConstraintViolationSummary cvs : cvsl) {
                if ((long)((Integer)expected.get(cvs.constrainClass)).intValue() == cvs.numberOfViolatingMutations) continue;
                throw new Exception("Unexpected " + cvs.constrainClass + " " + cvs.numberOfViolatingMutations);
            }
            if (!sawMRE) {
                throw new Exception("Did not see MutationsRejectedException");
            }
            try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
                Iterator iter = scanner.iterator();
                Map.Entry entry = (Map.Entry)iter.next();
                if (!(((Key)entry.getKey()).getRow().equals((Object)new Text("r1")) && ((Key)entry.getKey()).getColumnFamily().equals((Object)new Text("cf1")) && ((Key)entry.getKey()).getColumnQualifier().equals((Object)new Text("cq1")) && ((Value)entry.getValue()).equals((Object)new Value("123".getBytes(StandardCharsets.UTF_8))))) {
                    throw new Exception("Unexpected key or value " + entry.getKey() + " " + entry.getValue());
                }
                entry = (Map.Entry)iter.next();
                if (!(((Key)entry.getKey()).getRow().equals((Object)new Text("r1")) && ((Key)entry.getKey()).getColumnFamily().equals((Object)new Text("cf1")) && ((Key)entry.getKey()).getColumnQualifier().equals((Object)new Text("cq4")) && ((Value)entry.getValue()).equals((Object)new Value("789".getBytes(StandardCharsets.UTF_8))))) {
                    throw new Exception("Unexpected key or value " + entry.getKey() + " " + entry.getValue());
                }
                if (iter.hasNext()) {
                    entry = (Map.Entry)iter.next();
                    throw new Exception("Unexpected extra key or value " + entry.getKey() + " " + entry.getValue());
                }
            }
            return;
        }
    }
}

