/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class CloneTestIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void testProps() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String table1 = tableNames[0];
        String table2 = tableNames[1];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(CloneTestIT.getClientProps()).build();){
            c.tableOperations().create(table1);
            c.tableOperations().setProperty(table1, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "1M");
            c.tableOperations().setProperty(table1, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX.getKey(), "2M");
            c.tableOperations().setProperty(table1, Property.TABLE_FILE_MAX.getKey(), "23");
            this.writeDataAndClone(c, table1, table2);
            this.checkData(table2, c);
            this.checkMetadata(table2, c);
            HashMap<String, String> tableProps = new HashMap<String, String>();
            for (Map.Entry prop : c.tableOperations().getProperties(table2)) {
                tableProps.put((String)prop.getKey(), (String)prop.getValue());
            }
            Assert.assertEquals((Object)"500K", tableProps.get(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey()));
            Assert.assertEquals((Object)Property.TABLE_FILE_MAX.getDefaultValue(), tableProps.get(Property.TABLE_FILE_MAX.getKey()));
            Assert.assertEquals((Object)"2M", tableProps.get(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX.getKey()));
            c.tableOperations().delete(table1);
            c.tableOperations().delete(table2);
        }
    }

    private void checkData(String table2, AccumuloClient c) throws TableNotFoundException {
        try (Scanner scanner = c.createScanner(table2, Authorizations.EMPTY);){
            HashMap<String, String> expected = new HashMap<String, String>();
            expected.put("001:x", "9");
            expected.put("001:y", "7");
            expected.put("008:x", "3");
            expected.put("008:y", "4");
            HashMap<String, String> actual = new HashMap<String, String>();
            for (Map.Entry entry : scanner) {
                actual.put(((Key)entry.getKey()).getRowData() + ":" + ((Key)entry.getKey()).getColumnQualifierData(), ((Value)entry.getValue()).toString());
            }
            Assert.assertEquals(expected, actual);
        }
    }

    private void checkMetadata(String table, AccumuloClient client) throws Exception {
        try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)s);
            String tableId = (String)client.tableOperations().tableIdMap().get(table);
            Assert.assertNotNull((String)("Could not get table id for " + table), (Object)tableId);
            s.setRange(Range.prefix((CharSequence)tableId));
            Text cf = new Text();
            Text cq = new Text();
            int itemsInspected = 0;
            for (Map.Entry entry : s) {
                ++itemsInspected;
                Key k = (Key)entry.getKey();
                k.getColumnFamily(cf);
                k.getColumnQualifier(cq);
                if (cf.equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                    Path p = new Path(cq.toString());
                    FileSystem fs = cluster.getFileSystem();
                    Assert.assertTrue((String)("File does not exist: " + p), (boolean)fs.exists(p));
                    continue;
                }
                if (cf.equals((Object)MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.getColumnFamily())) {
                    Assert.assertEquals((String)"Saw unexpected cq", (Object)MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.getColumnQualifier(), (Object)cq);
                    Path tabletDir = new Path(((Value)entry.getValue()).toString());
                    Path tableDir = tabletDir.getParent();
                    Path tablesDir = tableDir.getParent();
                    Assert.assertEquals((Object)"tables", (Object)tablesDir.getName());
                    continue;
                }
                Assert.fail((String)("Got unexpected key-value: " + entry));
                throw new RuntimeException();
            }
            Assert.assertTrue((String)"Expected to find metadata entries", (itemsInspected > 0 ? 1 : 0) != 0);
        }
    }

    private BatchWriter writeData(String table1, AccumuloClient c) throws Exception {
        BatchWriter bw = c.createBatchWriter(table1);
        Mutation m1 = new Mutation((CharSequence)"001");
        m1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"9");
        m1.put((CharSequence)"data", (CharSequence)"y", (CharSequence)"7");
        Mutation m2 = new Mutation((CharSequence)"008");
        m2.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"3");
        m2.put((CharSequence)"data", (CharSequence)"y", (CharSequence)"4");
        bw.addMutation(m1);
        bw.addMutation(m2);
        bw.flush();
        return bw;
    }

    private void writeDataAndClone(AccumuloClient c, String table1, String table2) throws Exception {
        try (BatchWriter bw = this.writeData(table1, c);){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "500K");
            HashSet<String> exclude = new HashSet<String>();
            exclude.add(Property.TABLE_FILE_MAX.getKey());
            c.tableOperations().clone(table1, table2, true, props, exclude);
            Mutation m3 = new Mutation((CharSequence)"009");
            m3.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"1");
            m3.put((CharSequence)"data", (CharSequence)"y", (CharSequence)"2");
            bw.addMutation(m3);
        }
    }

    @Test
    public void testDeleteClone() throws Exception {
        String[] tableNames = this.getUniqueNames(3);
        String table1 = tableNames[0];
        String table2 = tableNames[1];
        String table3 = tableNames[2];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(CloneTestIT.getClientProps()).build();){
            AccumuloCluster cluster = CloneTestIT.getCluster();
            Assume.assumeTrue((boolean)(cluster instanceof MiniAccumuloClusterImpl));
            MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)cluster;
            String rootPath = mac.getConfig().getDir().getAbsolutePath();
            c.tableOperations().create(table3);
            this.writeData(table3, c).close();
            c.tableOperations().flush(table3, null, null, true);
            FileSystem fs = CloneTestIT.getCluster().getFileSystem();
            String id = (String)c.tableOperations().tableIdMap().get(table3);
            FileStatus[] status = fs.listStatus(new Path(rootPath + "/accumulo/tables/" + id));
            Assert.assertTrue((status.length > 0 ? 1 : 0) != 0);
            List diskUsage = c.tableOperations().getDiskUsage(Collections.singleton(table3));
            Assert.assertEquals((long)1L, (long)diskUsage.size());
            Assert.assertTrue((((DiskUsage)diskUsage.get(0)).getUsage() > 100L ? 1 : 0) != 0);
            c.tableOperations().delete(table3);
            Path tablePath = new Path(rootPath + "/accumulo/tables/" + id);
            if (fs.exists(tablePath)) {
                status = fs.listStatus(tablePath);
                Assert.assertTrue((status == null || status.length == 0 ? 1 : 0) != 0);
            }
            c.tableOperations().create(table1);
            this.writeDataAndClone(c, table1, table2);
            c.tableOperations().delete(table1);
            this.checkData(table2, c);
            c.tableOperations().compact(table2, null, null, true, true);
            this.checkData(table2, c);
            c.tableOperations().delete(table2);
        }
    }

    @Test
    public void testCloneWithSplits() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloneTestIT.getClientProps()).build();){
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int i = 0; i < 10; ++i) {
                splits.add(new Text(Integer.toString(i)));
                Mutation m = new Mutation((CharSequence)Integer.toString(i));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                mutations.add(m);
            }
            String[] tables = this.getUniqueNames(2);
            client.tableOperations().create(tables[0]);
            client.tableOperations().addSplits(tables[0], splits);
            try (BatchWriter bw = client.createBatchWriter(tables[0]);){
                bw.addMutations(mutations);
            }
            client.tableOperations().clone(tables[0], tables[1], true, null, null);
            client.tableOperations().deleteRows(tables[1], new Text("4"), new Text("8"));
            List<String> rows = Arrays.asList("0", "1", "2", "3", "4", "9");
            ArrayList<String> actualRows = new ArrayList<String>();
            for (Map.Entry entry : client.createScanner(tables[1], Authorizations.EMPTY)) {
                actualRows.add(((Key)entry.getKey()).getRow().toString());
            }
            Assert.assertEquals(rows, actualRows);
        }
    }
}

