/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.server.zookeeper.ZooReaderWriterFactory;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.junit.Test;

public class BackupMasterIT
extends ConfigurableMacBase {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        UtilWaitThread.sleep((long)1000L);
        Process backup = this.exec(Master.class, new String[0]);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String secret = this.getCluster().getSiteConfiguration().get(Property.INSTANCE_SECRET);
            IZooReaderWriter writer = new ZooReaderWriterFactory().getZooReaderWriter(this.cluster.getZooKeepers(), 30000, secret);
            String root = "/accumulo/" + client.instanceOperations().getInstanceID();
            List children = Collections.emptyList();
            do {
                UtilWaitThread.sleep((long)100L);
            } while ((children = writer.getChildren(root + "/masters/lock")).size() != 2);
            Collections.sort(children);
            UtilWaitThread.sleep((long)1000L);
            String lockPath = root + "/masters/lock/" + (String)children.get(0);
            byte[] data = writer.getData(lockPath, null);
            writer.getZooKeeper().setData(lockPath, data, -1);
            UtilWaitThread.sleep((long)500L);
            writer.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.FAIL);
            client.tableOperations().create(this.getUniqueNames(1)[0]);
        }
        finally {
            backup.destroy();
        }
    }
}

