/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class AddSplitIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void addSplitTest() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AddSplitIT.getClientProps()).build();){
            c.tableOperations().create(tableName);
            this.insertData(c, tableName, 1L);
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text(String.format("%09d", 333)));
            splits.add(new Text(String.format("%09d", 666)));
            c.tableOperations().addSplits(tableName, splits);
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            Collection actualSplits = c.tableOperations().listSplits(tableName);
            if (!splits.equals(new TreeSet(actualSplits))) {
                throw new Exception(splits + " != " + actualSplits);
            }
            this.verifyData(c, tableName, 1L);
            this.insertData(c, tableName, 2L);
            splits.add(new Text(String.format("%09d", 200)));
            splits.add(new Text(String.format("%09d", 500)));
            splits.add(new Text(String.format("%09d", 800)));
            c.tableOperations().addSplits(tableName, splits);
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            actualSplits = c.tableOperations().listSplits(tableName);
            if (!splits.equals(new TreeSet(actualSplits))) {
                throw new Exception(splits + " != " + actualSplits);
            }
            this.verifyData(c, tableName, 2L);
        }
    }

    private void verifyData(AccumuloClient client, String tableName, long ts) throws Exception {
        try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
            Iterator iter = scanner.iterator();
            for (int i = 0; i < 10000; ++i) {
                if (!iter.hasNext()) {
                    throw new Exception("row " + i + " not found");
                }
                Map.Entry entry = (Map.Entry)iter.next();
                String row = String.format("%09d", i);
                if (!((Key)entry.getKey()).getRow().equals((Object)new Text(row))) {
                    throw new Exception("unexpected row " + entry.getKey() + " " + i);
                }
                if (((Key)entry.getKey()).getTimestamp() != ts) {
                    throw new Exception("unexpected ts " + entry.getKey() + " " + ts);
                }
                if (Integer.parseInt(((Value)entry.getValue()).toString()) == i) continue;
                throw new Exception("unexpected value " + entry + " " + i);
            }
            if (iter.hasNext()) {
                throw new Exception("found more than expected " + iter.next());
            }
        }
    }

    private void insertData(AccumuloClient client, String tableName, long ts) throws Exception {
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            for (int i = 0; i < 10000; ++i) {
                String row = String.format("%09d", i);
                Mutation m = new Mutation(new Text(row));
                m.put(new Text("cf1"), new Text("cq1"), ts, new Value(Integer.toString(i).getBytes(StandardCharsets.UTF_8)));
                bw.addMutation(m);
            }
        }
    }
}

