/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.Assert;
import org.junit.Test;

public class UsersIT
extends AccumuloClusterHarness {
    @Test
    public void testCreateExistingUser() throws Exception {
        ClusterUser user0 = this.getUser(0);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(UsersIT.getClientProps()).build();){
            Set currentUsers = client.securityOperations().listLocalUsers();
            if (!currentUsers.contains(user0.getPrincipal())) {
                PasswordToken token = null;
                if (!UsersIT.saslEnabled()) {
                    token = new PasswordToken((CharSequence)user0.getPassword());
                }
                client.securityOperations().createLocalUser(user0.getPrincipal(), token);
            }
            try {
                client.securityOperations().createLocalUser(user0.getPrincipal(), new PasswordToken((CharSequence)"better_fail"));
                Assert.fail((String)"Creating a user that already exists should throw an exception");
            }
            catch (AccumuloSecurityException e) {
                Assert.assertSame((String)"Expected USER_EXISTS error", (Object)SecurityErrorCode.USER_EXISTS, (Object)e.getSecurityErrorCode());
                String msg = e.getMessage();
                Assert.assertTrue((String)("Error message didn't contain principal: '" + msg + "'"), (boolean)msg.contains(user0.getPrincipal()));
            }
        }
    }
}

