/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.SizeCompactionStrategy;
import org.apache.accumulo.test.TestCompactionStrategy;
import org.apache.accumulo.test.functional.ConfigurableCompactionIT;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class UserCompactionStrategyIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 180;
    }

    @After
    public void checkForDanglingFateLocks() {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            Assert.assertNotNull((Object)c);
            FunctionalTestUtils.assertNoDanglingFateLocks((ClientContext)c, UserCompactionStrategyIT.getCluster());
        }
    }

    @Test
    public void testDropA() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeFlush(c, tableName, "a");
            this.writeFlush(c, tableName, "b");
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            this.writeFlush(c, tableName, "c");
            this.writeFlush(c, tableName, "d");
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig(TestCompactionStrategy.class.getName());
            csConfig.setOptions((Map)ImmutableMap.of((Object)"dropPrefix", (Object)"A", (Object)"inputPrefix", (Object)"F"));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"c", (Object)"d"), this.getRows(c, tableName));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"c", (Object)"d"), this.getRows(c, tableName));
        }
    }

    private void testDropNone(Map<String, String> options) throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeFlush(c, tableName, "a");
            this.writeFlush(c, tableName, "b");
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig(TestCompactionStrategy.class.getName());
            csConfig.setOptions(options);
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b"), this.getRows(c, tableName));
        }
    }

    @Test
    public void testDropNone() throws Exception {
        this.testDropNone((Map<String, String>)ImmutableMap.of((Object)"inputPrefix", (Object)"Z"));
    }

    @Test
    public void testDropNone2() throws Exception {
        this.testDropNone((Map<String, String>)ImmutableMap.of((Object)"inputPrefix", (Object)"Z", (Object)"shouldCompact", (Object)"true"));
    }

    @Test
    public void testPerTableClasspath() throws Exception {
        Assume.assumeTrue((UserCompactionStrategyIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            File target = new File(System.getProperty("user.dir"), "target");
            Assert.assertTrue((target.mkdirs() || target.isDirectory() ? 1 : 0) != 0);
            File destFile = UserCompactionStrategyIT.installJar(target, "/TestCompactionStrat.jar");
            c.tableOperations().create(tableName);
            c.instanceOperations().setProperty(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + "context1", destFile.toString());
            c.tableOperations().setProperty(tableName, Property.TABLE_CLASSPATH.getKey(), "context1");
            c.tableOperations().addSplits(tableName, new TreeSet<Text>(Arrays.asList(new Text("efg"))));
            this.writeFlush(c, tableName, "a");
            this.writeFlush(c, tableName, "b");
            this.writeFlush(c, tableName, "h");
            this.writeFlush(c, tableName, "i");
            Assert.assertEquals((long)4L, (long)FunctionalTestUtils.countRFiles(c, tableName));
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig("org.apache.accumulo.test.EfgCompactionStrat");
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assert.assertEquals((long)3L, (long)FunctionalTestUtils.countRFiles(c, tableName));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assert.assertEquals((long)2L, (long)FunctionalTestUtils.countRFiles(c, tableName));
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    private static File installJar(File destDir, String jarFile) throws IOException {
        File destName = new File(destDir, new File(jarFile).getName());
        FileUtils.copyInputStreamToFile((InputStream)ConfigurableCompactionIT.class.getResourceAsStream(jarFile), (File)destName);
        return destName;
    }

    @Test
    public void testIterators() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeFlush(c, tableName, "a");
            this.writeFlush(c, tableName, "b");
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            this.writeFlush(c, tableName, "c");
            this.writeFlush(c, tableName, "d");
            Assert.assertEquals((long)3L, (long)FunctionalTestUtils.countRFiles(c, tableName));
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig(TestCompactionStrategy.class.getName());
            csConfig.setOptions((Map)ImmutableMap.of((Object)"inputPrefix", (Object)"F"));
            IteratorSetting iterConf = new IteratorSetting(21, "myregex", RegExFilter.class);
            RegExFilter.setRegexs((IteratorSetting)iterConf, (String)"a|c", null, null, null, (boolean)false);
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig).setIterators(Arrays.asList(iterConf)));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), this.getRows(c, tableName));
            Assert.assertEquals((long)2L, (long)FunctionalTestUtils.countRFiles(c, tableName));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), this.getRows(c, tableName));
            Assert.assertEquals((long)1L, (long)FunctionalTestUtils.countRFiles(c, tableName));
        }
    }

    @Test
    public void testFileSize() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeRandomValue(c, tableName, 65536);
            this.writeRandomValue(c, tableName, 65536);
            this.writeRandomValue(c, tableName, 512);
            this.writeRandomValue(c, tableName, 128);
            this.writeRandomValue(c, tableName, 64);
            Assert.assertEquals((long)5L, (long)FunctionalTestUtils.countRFiles(c, tableName));
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig(SizeCompactionStrategy.class.getName());
            csConfig.setOptions((Map)ImmutableMap.of((Object)"size", (Object)"32768"));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assert.assertEquals((long)3L, (long)FunctionalTestUtils.countRFiles(c, tableName));
            csConfig = new CompactionStrategyConfig(SizeCompactionStrategy.class.getName());
            csConfig.setOptions((Map)ImmutableMap.of((Object)"size", (Object)"131072"));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assert.assertEquals((long)1L, (long)FunctionalTestUtils.countRFiles(c, tableName));
        }
    }

    @Test
    public void testConcurrent() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeRandomValue(c, tableName, 65536);
            this.writeRandomValue(c, tableName, 65536);
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(false));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assert.assertEquals((long)1L, (long)FunctionalTestUtils.countRFiles(c, tableName));
            this.writeRandomValue(c, tableName, 65536);
            IteratorSetting iterConfig = new IteratorSetting(30, SlowIterator.class);
            SlowIterator.setSleepTime(iterConfig, 1000L);
            long t1 = System.currentTimeMillis();
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(false).setIterators(Arrays.asList(iterConfig)));
            try {
                c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
                if (System.currentTimeMillis() - t1 < 2000L) {
                    Assert.fail((String)"Expected compaction to fail because another concurrent compaction set iterators");
                }
            }
            catch (AccumuloException accumuloException) {
                // empty catch block
            }
        }
    }

    void writeRandomValue(AccumuloClient c, String tableName, int size) throws Exception {
        SecureRandom rand = new SecureRandom();
        byte[] data1 = new byte[size];
        ((Random)rand).nextBytes(data1);
        try (BatchWriter bw = c.createBatchWriter(tableName);){
            Mutation m1 = new Mutation((CharSequence)("r" + rand.nextInt(909090)));
            m1.put((CharSequence)"data", (CharSequence)"bl0b", new Value(data1));
            bw.addMutation(m1);
        }
        c.tableOperations().flush(tableName, null, null, true);
    }

    private Set<String> getRows(AccumuloClient c, String tableName) throws TableNotFoundException {
        HashSet<String> rows = new HashSet<String>();
        try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
            for (Map.Entry entry : scanner) {
                rows.add(((Key)entry.getKey()).getRowData().toString());
            }
        }
        return rows;
    }

    private void writeFlush(AccumuloClient client, String tablename, String row) throws Exception {
        try (BatchWriter bw = client.createBatchWriter(tablename);){
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
        }
        client.tableOperations().flush(tablename, null, null, true);
    }
}

