/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.server.master.state.ClosableIterator;
import org.apache.accumulo.server.master.state.MetaDataStateStore;
import org.apache.accumulo.server.master.state.RootTabletStateStore;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class MasterRepairsDualAssignmentIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 300;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.MASTER_RECOVERY_DELAY, "5s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            boolean allAssigned;
            ClientContext context = (ClientContext)c;
            String table = this.getUniqueNames(1)[0];
            c.securityOperations().grantTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
            c.securityOperations().grantTablePermission("root", RootTable.NAME, TablePermission.WRITE);
            c.tableOperations().create(table);
            TreeSet<Text> partitions = new TreeSet<Text>();
            for (String part : "a b c d e f g h i j k l m n o p q r s t u v w x y z".split(" ")) {
                partitions.add(new Text(part));
            }
            c.tableOperations().addSplits(table, partitions);
            HashSet<TServerInstance> states = new HashSet<TServerInstance>();
            HashSet<TabletLocationState> oldLocations = new HashSet<TabletLocationState>();
            MetaDataStateStore store = new MetaDataStateStore(context, null);
            while (states.size() < 2) {
                UtilWaitThread.sleep((long)250L);
                oldLocations.clear();
                for (TabletLocationState tls : store) {
                    if (tls.current == null) continue;
                    states.add(tls.current);
                    oldLocations.add(tls);
                }
            }
            Assert.assertEquals((long)2L, (long)states.size());
            this.cluster.killProcess(ServerType.TABLET_SERVER, (ProcessReference)((Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)).iterator().next());
            HashSet<TServerInstance> replStates = new HashSet<TServerInstance>();
            do {
                UtilWaitThread.sleep((long)1000L);
                states.clear();
                replStates.clear();
                allAssigned = true;
                for (TabletLocationState tls : store) {
                    if (tls != null && tls.current != null) {
                        states.add(tls.current);
                        continue;
                    }
                    if (tls != null && tls.extent.equals((Object)new KeyExtent(ReplicationTable.ID, null, null))) {
                        replStates.add(tls.current);
                        continue;
                    }
                    allAssigned = false;
                }
                System.out.println(states + " size " + states.size() + " allAssigned " + allAssigned);
            } while (states.size() == 2 || !allAssigned);
            Assert.assertEquals((long)1L, (long)replStates.size());
            Assert.assertEquals((long)1L, (long)states.size());
            TabletLocationState moved = null;
            for (TabletLocationState old : oldLocations) {
                if (states.contains(old.current)) continue;
                moved = old;
            }
            Assert.assertNotEquals(null, moved);
            BatchWriter bw = c.createBatchWriter(MetadataTable.NAME, new BatchWriterConfig());
            Mutation assignment = new Mutation(moved.extent.getMetadataEntry());
            moved.current.putLocation(assignment);
            bw.addMutation(assignment);
            bw.close();
            this.waitForCleanStore(store);
            bw = c.createBatchWriter(MetadataTable.NAME, new BatchWriterConfig());
            assignment = new Mutation(new KeyExtent(MetadataTable.ID, null, null).getMetadataEntry());
            moved.current.putLocation(assignment);
            bw.addMutation(assignment);
            bw.close();
            this.waitForCleanStore((MetaDataStateStore)new RootTabletStateStore(context, null));
        }
    }

    private void waitForCleanStore(MetaDataStateStore store) {
        while (true) {
            try (ClosableIterator iter = store.iterator();){
                Iterators.size((Iterator)iter);
            }
            catch (Exception ex) {
                System.out.println(ex);
                UtilWaitThread.sleep((long)250L);
                continue;
            }
            break;
        }
    }
}

