/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.server.util.AccumuloStatus;
import org.apache.accumulo.server.zookeeper.ZooReaderWriterFactory;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class ExistingMacIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_NATIVEMAP_ENABLED, "false");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private void createEmptyConfig(File confFile) throws IOException {
        Configuration conf = new Configuration(false);
        FileOutputStream hcOut = new FileOutputStream(confFile);
        conf.writeXml((OutputStream)hcOut);
        ((OutputStream)hcOut).close();
    }

    @Test
    public void testExistingInstance() throws Exception {
        AccumuloClient client = this.getCluster().createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        client.tableOperations().create("table1");
        try (BatchWriter bw = client.createBatchWriter("table1");){
            Mutation m1 = new Mutation((CharSequence)"00081");
            m1.put((CharSequence)"math", (CharSequence)"sqroot", (CharSequence)"9");
            m1.put((CharSequence)"math", (CharSequence)"sq", (CharSequence)"6560");
            bw.addMutation(m1);
        }
        client.tableOperations().flush("table1", null, null, true);
        client.tableOperations().flush(MetadataTable.NAME, null, null, true);
        client.tableOperations().flush(RootTable.NAME, null, null, true);
        Set procs = this.getCluster().getProcesses().entrySet();
        for (Map.Entry entry : procs) {
            if (entry.getKey() == ServerType.ZOOKEEPER) continue;
            for (ProcessReference pr : (Collection)entry.getValue()) {
                this.getCluster().killProcess((ServerType)entry.getKey(), pr);
            }
        }
        DefaultConfiguration defaultConfig = DefaultConfiguration.getInstance();
        long l = ConfigurationTypeHelper.getTimeInMillis((String)((String)this.getCluster().getConfig().getSiteConfig().get(Property.INSTANCE_ZK_TIMEOUT.getKey())));
        IZooReaderWriter zrw = new ZooReaderWriterFactory().getZooReaderWriter(this.getCluster().getZooKeepers(), (int)l, defaultConfig.get(Property.INSTANCE_SECRET));
        String zInstanceRoot = "/accumulo/" + client.instanceOperations().getInstanceID();
        while (!AccumuloStatus.isAccumuloOffline((IZooReader)zrw, (String)zInstanceRoot)) {
            log.debug("Accumulo services still have their ZK locks held");
            Thread.sleep(1000L);
        }
        File hadoopConfDir = ExistingMacIT.createTestDir(ExistingMacIT.class.getSimpleName() + "_hadoop_conf");
        FileUtils.deleteQuietly((File)hadoopConfDir);
        Assert.assertTrue((boolean)hadoopConfDir.mkdirs());
        this.createEmptyConfig(new File(hadoopConfDir, "core-site.xml"));
        this.createEmptyConfig(new File(hadoopConfDir, "hdfs-site.xml"));
        File testDir2 = ExistingMacIT.createTestDir(ExistingMacIT.class.getSimpleName() + "_2");
        FileUtils.deleteQuietly((File)testDir2);
        MiniAccumuloConfigImpl macConfig2 = new MiniAccumuloConfigImpl(testDir2, "notused");
        macConfig2.useExistingInstance(new File(this.getCluster().getConfig().getConfDir(), "accumulo.properties"), hadoopConfDir);
        MiniAccumuloClusterImpl accumulo2 = new MiniAccumuloClusterImpl(macConfig2);
        accumulo2.start();
        client = accumulo2.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        try (Scanner scanner = client.createScanner("table1", Authorizations.EMPTY);){
            int sum = 0;
            for (Map.Entry entry : scanner) {
                sum += Integer.parseInt(((Value)entry.getValue()).toString());
            }
            Assert.assertEquals((long)6569L, (long)sum);
        }
        accumulo2.stop();
    }

    @Test
    public void testExistingRunningInstance() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            client.tableOperations().create(table);
            try (BatchWriter bw = client.createBatchWriter(table);){
                Mutation m = new Mutation((CharSequence)"foo");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
            File hadoopConfDir = ExistingMacIT.createTestDir(ExistingMacIT.class.getSimpleName() + "_hadoop_conf_2");
            FileUtils.deleteQuietly((File)hadoopConfDir);
            Assert.assertTrue((boolean)hadoopConfDir.mkdirs());
            this.createEmptyConfig(new File(hadoopConfDir, "core-site.xml"));
            this.createEmptyConfig(new File(hadoopConfDir, "hdfs-site.xml"));
            File testDir2 = ExistingMacIT.createTestDir(ExistingMacIT.class.getSimpleName() + "_3");
            FileUtils.deleteQuietly((File)testDir2);
            MiniAccumuloConfigImpl macConfig2 = new MiniAccumuloConfigImpl(testDir2, "notused");
            macConfig2.useExistingInstance(new File(this.getCluster().getConfig().getConfDir(), "accumulo.properties"), hadoopConfDir);
            System.out.println("conf " + new File(this.getCluster().getConfig().getConfDir(), "accumulo.properties"));
            MiniAccumuloClusterImpl accumulo2 = new MiniAccumuloClusterImpl(macConfig2);
            try {
                accumulo2.start();
                Assert.fail((String)"A 2nd MAC instance should not be able to start over an existing MAC instance");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

