/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.clientImpl.thrift.ThriftNotActiveServiceException;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class DetectDeadTabletServersIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            log.info("verifying that everything is up");
            Iterators.size((Iterator)c.createScanner(MetadataTable.NAME, Authorizations.EMPTY).iterator());
            MasterMonitorInfo stats = this.getStats(c);
            Assert.assertEquals((long)2L, (long)stats.tServerInfo.size());
            Assert.assertEquals((long)0L, (long)stats.badTServers.size());
            Assert.assertEquals((long)0L, (long)stats.deadTabletServers.size());
            log.info("Killing a tablet server");
            this.getCluster().killProcess(ServerType.TABLET_SERVER, (ProcessReference)((Collection)this.getCluster().getProcesses().get(ServerType.TABLET_SERVER)).iterator().next());
            while (true) {
                stats = this.getStats(c);
                if (stats.tServerInfo.size() != 2) break;
                UtilWaitThread.sleep((long)500L);
            }
            Assert.assertEquals((long)1L, (long)stats.tServerInfo.size());
            Assert.assertEquals((long)1L, (long)(stats.badTServers.size() + stats.deadTabletServers.size()));
            while (true) {
                stats = this.getStats(c);
                if (stats.deadTabletServers.size() != 0) break;
                UtilWaitThread.sleep((long)500L);
            }
            Assert.assertEquals((long)1L, (long)stats.tServerInfo.size());
            Assert.assertEquals((long)0L, (long)stats.badTServers.size());
            Assert.assertEquals((long)1L, (long)stats.deadTabletServers.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterMonitorInfo getStats(AccumuloClient c) throws Exception {
        ClientContext context = (ClientContext)c;
        MasterClientService.Client client = null;
        while (true) {
            try {
                client = MasterClient.getConnectionWithRetry((ClientContext)context);
                log.info("Fetching master stats");
                MasterMonitorInfo masterMonitorInfo = client.getMasterStats(TraceUtil.traceInfo(), context.rpcCreds());
                return masterMonitorInfo;
            }
            catch (ThriftNotActiveServiceException e) {
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            finally {
                if (client == null) continue;
                MasterClient.close((MasterClientService.Iface)client);
                continue;
            }
            break;
        }
    }
}

