/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class CountNameNodeOpsBulkIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.useMiniDFS(true);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "URLCONNECTION_SSRF_FD"}, justification="path provided by test; url provided by test")
    private Map<?, ?> getStats() throws Exception {
        String uri = this.getCluster().getMiniDfs().getHttpUri(0);
        URL url = new URL(uri + "/jmx");
        log.debug("Fetching web page " + url);
        String jsonString = FunctionalTestUtils.readAll(url.openStream());
        Gson gson = new Gson();
        Map jsonObject = (Map)gson.fromJson(jsonString, Map.class);
        List beans = (List)jsonObject.get("beans");
        for (Object bean : beans) {
            Map map = (Map)bean;
            if (!map.get("name").toString().equals("Hadoop:service=NameNode,name=NameNodeActivity")) continue;
            return map;
        }
        return new HashMap(0);
    }

    private long getStat(Map<?, ?> map, String stat) {
        return (long)Double.parseDouble(map.get(stat).toString());
    }

    @Test
    public void compareOldNewBulkImportTest() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.getCluster().getClusterControl().kill(ServerType.GARBAGE_COLLECTOR, "localhost");
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "2000");
            c.tableOperations().setProperty(tableName, Property.TABLE_FILE_MAX.getKey(), "2000");
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int i = 1; i < 15; ++i) {
                splits.add(new Text(Integer.toHexString(i)));
            }
            c.tableOperations().addSplits(tableName, splits);
            MasterMonitorInfo stats = this.getCluster().getMasterMonitorInfo();
            Assert.assertEquals((long)1L, (long)stats.tServerInfo.size());
            log.info("Creating lots of bulk import files");
            FileSystem fs = this.getCluster().getFileSystem();
            Path basePath = this.getCluster().getTemporaryPath();
            Path base = new Path(basePath, "testBulkLoad" + tableName);
            fs.delete(base, true);
            fs.mkdirs(base);
            ExecutorService es = Executors.newFixedThreadPool(5);
            ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
            int i = 0;
            while (i < 10) {
                int which = i++;
                futures.add(es.submit(() -> {
                    Path files = new Path(base, "files" + which);
                    fs.mkdirs(files);
                    for (int i1 = 0; i1 < 100; ++i1) {
                        FileSKVWriter writer = FileOperations.getInstance().newWriterBuilder().forFile(files + "/bulk_" + i1 + "." + "rf", fs, fs.getConf(), CryptoServiceFactory.newDefaultInstance()).withTableConfiguration((AccumuloConfiguration)DefaultConfiguration.getInstance()).build();
                        writer.startDefaultLocalityGroup();
                        for (int j = 256; j < 4095; j += 3) {
                            writer.append(new Key((CharSequence)Integer.toHexString(j)), new Value(new byte[0]));
                        }
                        writer.close();
                    }
                    return files.toString();
                }));
            }
            ArrayList<String> dirs = new ArrayList<String>();
            for (Future future : futures) {
                dirs.add((String)future.get());
            }
            log.info("Importing");
            long startOps = this.getStat(this.getStats(), "FileInfoOps");
            long now = System.currentTimeMillis();
            ArrayList<Future<Object>> errs = new ArrayList<Future<Object>>();
            for (String string : dirs) {
                errs.add(es.submit(() -> {
                    c.tableOperations().importDirectory(dir).to(tableName).load();
                    return null;
                }));
            }
            for (Future future : errs) {
                future.get();
            }
            es.shutdown();
            es.awaitTermination(2L, TimeUnit.MINUTES);
            log.info(String.format("Completed in %.2f seconds", (double)(System.currentTimeMillis() - now) / 1000.0));
            UtilWaitThread.sleepUninterruptibly((long)30L, (TimeUnit)TimeUnit.SECONDS);
            Map<?, ?> map = this.getStats();
            map.forEach((k, v) -> {
                try {
                    if (v != null && Double.parseDouble(v.toString()) > 0.0) {
                        log.debug("{}:{}", k, v);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            long l = this.getStat(map, "FileInfoOps") - startOps;
            log.info("New bulk import used {} opts, vs old using 2060", (Object)l);
            Assert.assertEquals((String)"unexpected number of FileInfoOps", (long)20L, (long)l);
        }
    }
}

