/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.junit.Assert;
import org.junit.Test;

public class CloseScannerIT
extends AccumuloClusterHarness {
    static final int ROWS = 1000;
    static final int COLS = 1000;

    @Test
    public void testManyScans() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloseScannerIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            ReadWriteIT.ingest(client, CloseScannerIT.getClientInfo(), 1000, 1000, 50, 0, tableName);
            client.tableOperations().flush(tableName, null, null, true);
            for (int i = 0; i < 200; ++i) {
                try (Scanner scanner = CloseScannerIT.createScanner(client, tableName, i);){
                    scanner.setRange(new Range());
                    scanner.setReadaheadThreshold(i % 2 == 0 ? 0L : 3L);
                    for (int j = 0; j < i % 7 + 1; ++j) {
                        Iterators.get((Iterator)scanner.iterator(), (int)10);
                    }
                    continue;
                }
            }
            List tservers = client.instanceOperations().getTabletServers();
            int activeScans = 0;
            for (String tserver : tservers) {
                activeScans += client.instanceOperations().getActiveScans(tserver).size();
            }
            Assert.assertTrue((activeScans < 3 ? 1 : 0) != 0);
        }
    }

    private static Scanner createScanner(AccumuloClient client, String tableName, int i) throws Exception {
        Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);
        if (i % 2 == 0) {
            scanner = new IsolatedScanner(scanner);
        }
        return scanner;
    }
}

