/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.cluster.ClusterUsers;
import org.apache.accumulo.cluster.standalone.StandaloneAccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.harness.conf.AccumuloClusterConfiguration;
import org.apache.accumulo.harness.conf.AccumuloClusterPropertyConfiguration;
import org.apache.accumulo.harness.conf.StandaloneAccumuloClusterConfiguration;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.categories.StandaloneCapableClusterTests;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StandaloneCapableClusterTests.class})
public abstract class AccumuloClusterHarness
extends AccumuloITBase
implements MiniClusterConfigurationCallback,
ClusterUsers {
    private static final Logger log = LoggerFactory.getLogger(AccumuloClusterHarness.class);
    private static final String TRUE = Boolean.toString(true);
    private static boolean initialized = false;
    protected static AccumuloCluster cluster;
    protected static ClusterType type;
    protected static AccumuloClusterPropertyConfiguration clusterConf;
    protected static TestingKdc krb;

    @BeforeClass
    public static void setUpHarness() throws Exception {
        clusterConf = AccumuloClusterPropertyConfiguration.get();
        type = clusterConf.getClusterType();
        if (type == ClusterType.MINI && TRUE.equals(System.getProperty("org.apache.accumulo.test.functional.useKrbForIT"))) {
            krb = new TestingKdc();
            krb.start();
            log.info("MiniKdc started");
        }
        initialized = true;
    }

    @AfterClass
    public static void tearDownHarness() {
        if (krb != null) {
            krb.stop();
        }
    }

    public static TestingKdc getKdc() {
        return krb;
    }

    @Before
    public void setupCluster() throws Exception {
        Assume.assumeTrue((boolean)this.canRunTest(type));
        switch (type) {
            case MINI: {
                MiniClusterHarness miniClusterHarness = new MiniClusterHarness();
                cluster = miniClusterHarness.create(this, AccumuloClusterHarness.getAdminToken(), krb);
                if (krb == null) break;
                ClusterUser rootUser = krb.getRootUser();
                UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
                break;
            }
            case STANDALONE: {
                StandaloneAccumuloClusterConfiguration conf = (StandaloneAccumuloClusterConfiguration)clusterConf;
                StandaloneAccumuloCluster standaloneCluster = new StandaloneAccumuloCluster(conf.getClientInfo(), conf.getTmpDirectory(), conf.getUsers(), conf.getServerAccumuloConfDir());
                standaloneCluster.setAccumuloHome(conf.getAccumuloHome());
                standaloneCluster.setClientAccumuloConfDir(conf.getClientAccumuloConfDir());
                standaloneCluster.setHadoopConfDir(conf.getHadoopConfDir());
                standaloneCluster.setServerCmdPrefix(conf.getServerCmdPrefix() == null ? "" : conf.getServerCmdPrefix());
                standaloneCluster.setClientCmdPrefix(conf.getClientCmdPrefix() == null ? "" : conf.getClientCmdPrefix());
                cluster = standaloneCluster;
                if (!AccumuloClusterHarness.saslEnabled()) break;
                Configuration hadoopConfiguration = standaloneCluster.getHadoopConfiguration();
                UserGroupInformation.setConfiguration((Configuration)hadoopConfiguration);
                UserGroupInformation.loginUserFromKeytab((String)conf.getAdminPrincipal(), (String)conf.getAdminKeytab().getAbsolutePath());
                break;
            }
            default: {
                throw new RuntimeException("Unhandled type");
            }
        }
        if (type.isDynamic()) {
            cluster.start();
        } else {
            log.info("Removing tables which appear to be from a previous test run");
            this.cleanupTables();
            log.info("Removing users which appear to be from a previous test run");
            this.cleanupUsers();
        }
        switch (type) {
            case MINI: {
                if (krb == null) break;
                String traceTable = Property.TRACE_TABLE.getDefaultValue();
                ClusterUser systemUser = krb.getAccumuloServerUser();
                ClusterUser rootUser = krb.getRootUser();
                UserGroupInformation.loginUserFromKeytab((String)systemUser.getPrincipal(), (String)systemUser.getKeytab().getAbsolutePath());
                UserGroupInformation.loginUserFromKeytab((String)systemUser.getPrincipal(), (String)systemUser.getKeytab().getAbsolutePath());
                AccumuloClient c = cluster.createAccumuloClient(systemUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                c.close();
                UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
                try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloClusterHarness.getClientProps()).build();){
                    client.tableOperations().create(traceTable);
                    client.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.READ);
                    client.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.WRITE);
                    client.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.ALTER_TABLE);
                    break;
                }
            }
        }
    }

    public void cleanupTables() throws Exception {
        String tablePrefix = this.getClass().getSimpleName() + "_";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloClusterHarness.getClientProps()).build();){
            TableOperations tops = client.tableOperations();
            for (String table : tops.list()) {
                if (!table.startsWith(tablePrefix)) continue;
                log.debug("Removing table {}", (Object)table);
                tops.delete(table);
            }
        }
    }

    public void cleanupUsers() throws Exception {
        String userPrefix = this.getClass().getSimpleName();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloClusterHarness.getClientProps()).build();){
            SecurityOperations secOps = client.securityOperations();
            for (String user : secOps.listLocalUsers()) {
                if (!user.startsWith(userPrefix)) continue;
                log.info("Dropping local user {}", (Object)user);
                secOps.dropLocalUser(user);
            }
        }
    }

    @After
    public void teardownCluster() throws Exception {
        if (cluster != null) {
            if (type.isDynamic()) {
                cluster.stop();
            } else {
                log.info("Removing tables which appear to be from the current test");
                this.cleanupTables();
                log.info("Removing users which appear to be from the current test");
                this.cleanupUsers();
            }
        }
    }

    public static AccumuloCluster getCluster() {
        Preconditions.checkState((boolean)initialized);
        return cluster;
    }

    public static ClusterControl getClusterControl() {
        Preconditions.checkState((boolean)initialized);
        return cluster.getClusterControl();
    }

    public static ClusterType getClusterType() {
        Preconditions.checkState((boolean)initialized);
        return type;
    }

    public static String getAdminPrincipal() {
        Preconditions.checkState((boolean)initialized);
        return clusterConf.getAdminPrincipal();
    }

    public static Properties getClientProps() {
        Preconditions.checkState((boolean)initialized);
        return AccumuloClusterHarness.getCluster().getClientProperties();
    }

    public static ClientInfo getClientInfo() {
        Preconditions.checkState((boolean)initialized);
        return ClientInfo.from((Properties)AccumuloClusterHarness.getCluster().getClientProperties());
    }

    public static ServerContext getServerContext() {
        return AccumuloClusterHarness.getCluster().getServerContext();
    }

    public static boolean saslEnabled() {
        if (initialized) {
            return AccumuloClusterHarness.getClientInfo().saslEnabled();
        }
        return false;
    }

    public static AuthenticationToken getAdminToken() {
        Preconditions.checkState((boolean)initialized);
        return clusterConf.getAdminToken();
    }

    public ClusterUser getAdminUser() {
        switch (type) {
            case MINI: {
                if (krb == null) {
                    PasswordToken passwordToken = (PasswordToken)AccumuloClusterHarness.getAdminToken();
                    return new ClusterUser(AccumuloClusterHarness.getAdminPrincipal(), new String(passwordToken.getPassword(), StandardCharsets.UTF_8));
                }
                return krb.getRootUser();
            }
            case STANDALONE: {
                return new ClusterUser(AccumuloClusterHarness.getAdminPrincipal(), ((StandaloneAccumuloClusterConfiguration)clusterConf).getAdminKeytab());
            }
        }
        throw new RuntimeException("Unknown cluster type");
    }

    public ClusterUser getUser(int offset) {
        switch (type) {
            case MINI: {
                if (krb != null) {
                    return krb.getClientPrincipal(offset);
                }
                String principal = this.getClass().getSimpleName() + "_" + this.testName.getMethodName() + "_" + offset;
                return new ClusterUser(principal, principal);
            }
            case STANDALONE: {
                return ((StandaloneAccumuloCluster)cluster).getUser(offset);
            }
        }
        throw new RuntimeException("Unknown cluster type");
    }

    public static FileSystem getFileSystem() throws IOException {
        Preconditions.checkState((boolean)initialized);
        return cluster.getFileSystem();
    }

    public static AccumuloClusterConfiguration getClusterConfiguration() {
        Preconditions.checkState((boolean)initialized);
        return clusterConf;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
    }

    public boolean canRunTest(ClusterType type) {
        return true;
    }

    public Path getUsableDir() throws IllegalArgumentException {
        return cluster.getTemporaryPath();
    }

    public static enum ClusterType {
        MINI,
        STANDALONE;


        public boolean isDynamic() {
            return this == MINI;
        }
    }
}

