/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.io.Text;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

public class TraceCommand
extends Shell.Command {
    private TraceScope traceScope = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException {
        if (cl.getArgs().length == 1) {
            if (cl.getArgs()[0].equalsIgnoreCase("on")) {
                if (this.traceScope != null) return 0;
                this.traceScope = Trace.startSpan((String)("shell:" + shellState.getAccumuloClient().whoami()), (Sampler)Sampler.ALWAYS);
                return 0;
            }
            if (!cl.getArgs()[0].equalsIgnoreCase("off")) throw new BadArgumentException("Argument must be 'on' or 'off'", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
            if (this.traceScope != null) {
                long trace = this.traceScope.getSpan().getTraceId();
                this.traceScope.close();
                this.traceScope = null;
                StringBuilder sb = new StringBuilder();
                int traceCount = 0;
                for (int i = 0; i < 30; ++i) {
                    sb = new StringBuilder();
                    try {
                        Map properties = shellState.getAccumuloClient().instanceOperations().getSystemConfiguration();
                        String table = (String)properties.get(Property.TRACE_TABLE.getKey());
                        String user = shellState.getAccumuloClient().whoami();
                        Authorizations auths = shellState.getAccumuloClient().securityOperations().getUserAuthorizations(user);
                        Scanner scanner = shellState.getAccumuloClient().createScanner(table, auths);
                        scanner.setRange(new Range(new Text(Long.toHexString(trace))));
                        StringBuilder finalSB = sb;
                        traceCount = TraceDump.printTrace((Scanner)scanner, line -> {
                            try {
                                finalSB.append(line + "\n");
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                        });
                        if (traceCount > 0) {
                            shellState.getReader().print((CharSequence)sb.toString());
                            break;
                        }
                    }
                    catch (Exception ex) {
                        shellState.printException(ex);
                    }
                    shellState.getReader().println((CharSequence)"Waiting for trace information");
                    shellState.getReader().flush();
                    UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                if (traceCount >= 0) return 0;
                shellState.getReader().print((CharSequence)sb.toString());
                return 0;
            }
            shellState.getReader().println((CharSequence)"Not tracing");
            return 0;
        }
        if (cl.getArgs().length == 0) {
            shellState.getReader().println((CharSequence)(Trace.isTracing() ? "on" : "off"));
            return 0;
        } else {
            shellState.printException(new IllegalArgumentException("Expected 0 or 1 argument. There were " + cl.getArgs().length + "."));
            this.printHelp(shellState);
            return 1;
        }
    }

    @Override
    public String description() {
        return "turns tracing on or off";
    }

    @Override
    public String usage() {
        return this.getName() + " [ on | off ]";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

