/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class GetGroupsCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        Map groups = shellState.getAccumuloClient().tableOperations().getLocalityGroups(tableName);
        for (Map.Entry entry : groups.entrySet()) {
            shellState.getReader().println((CharSequence)((String)entry.getKey() + "=" + LocalityGroupUtil.encodeColumnFamilies((Set)((Set)entry.getValue()))));
        }
        return 0;
    }

    @Override
    public String description() {
        return "gets the locality groups for a given table";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        opts.addOption(OptUtil.tableOpt("table to fetch locality groups from"));
        return opts;
    }
}

