/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

public class FateTxId {
    private static final String PREFIX = "FATE[";
    private static final String SUFFIX = "]";
    private static final Pattern PATTERN = Pattern.compile(Pattern.quote("FATE[") + "[0-9a-fA-F]+" + Pattern.quote("]"));

    private static String getHex(String fmtTid) {
        return fmtTid.substring(PREFIX.length(), fmtTid.length() - SUFFIX.length());
    }

    public static boolean isFormatedTid(String fmtTid) {
        return PATTERN.matcher(fmtTid).matches();
    }

    public static long fromString(String fmtTid) {
        Preconditions.checkArgument((fmtTid.startsWith(PREFIX) && fmtTid.endsWith(SUFFIX) ? 1 : 0) != 0);
        return Long.parseLong(FateTxId.getHex(fmtTid), 16);
    }

    public static String formatTid(long tid) {
        return String.format("%s%016x%s", PREFIX, tid, SUFFIX);
    }
}

