/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.google.common.annotations.VisibleForTesting;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.zookeeper.KeeperException;

public class MonitorUtil {
    public static String getLocation(ClientContext context) throws KeeperException, InterruptedException {
        return MonitorUtil.getLocation(new ZooReader(context.getZooKeepers(), 30000), context);
    }

    @VisibleForTesting
    static String getLocation(ZooReader zr, ClientContext context) throws KeeperException, InterruptedException {
        try {
            byte[] loc = zr.getData(context.getZooKeeperRoot() + "/monitor/http_addr", null);
            return loc == null ? null : new String(loc, StandardCharsets.UTF_8);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
    }
}

