/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.tabletserver.log;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;

public class LogEntry {
    public final KeyExtent extent;
    public final long timestamp;
    public final String server;
    public final String filename;
    private static final Text EMPTY_TEXT = new Text();

    public LogEntry(LogEntry le) {
        this.extent = le.extent;
        this.timestamp = le.timestamp;
        this.server = le.server;
        this.filename = le.filename;
    }

    public LogEntry(KeyExtent extent, long timestamp, String server, String filename) {
        this.extent = extent;
        this.timestamp = timestamp;
        this.server = server;
        this.filename = filename;
    }

    public String toString() {
        return this.extent + " " + this.filename;
    }

    public String getName() {
        return this.server + "/" + this.filename;
    }

    public byte[] toBytes() throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        this.extent.write((DataOutput)out);
        out.writeLong(this.timestamp);
        out.writeUTF(this.server);
        out.writeUTF(this.filename);
        return Arrays.copyOf(out.getData(), out.getLength());
    }

    public static LogEntry fromBytes(byte[] bytes) throws IOException {
        DataInputBuffer inp = new DataInputBuffer();
        inp.reset(bytes, bytes.length);
        KeyExtent extent = new KeyExtent();
        extent.readFields((DataInput)inp);
        long timestamp = inp.readLong();
        String server = inp.readUTF();
        String filename = inp.readUTF();
        return new LogEntry(extent, timestamp, server, filename);
    }

    public static LogEntry fromKeyValue(Key key, String value) {
        String qualifier = key.getColumnQualifierData().toString();
        if (qualifier.indexOf(47) < 1) {
            throw new IllegalArgumentException("Bad key for log entry: " + key);
        }
        KeyExtent extent = new KeyExtent(key.getRow(), EMPTY_TEXT);
        String[] parts = qualifier.split("/", 2);
        String server = parts[0];
        parts = value.split("\\|")[0].split(";");
        String filename = parts[parts.length - 1];
        long timestamp = key.getTimestamp();
        return new LogEntry(extent, timestamp, server, filename);
    }

    public static LogEntry fromKeyValue(Key key, Value value) {
        return LogEntry.fromKeyValue(key, value.toString());
    }

    public Text getRow() {
        return this.extent.getMetadataEntry();
    }

    public Text getColumnFamily() {
        return MetadataSchema.TabletsSection.LogColumnFamily.NAME;
    }

    public String getUniqueID() {
        String[] parts = this.filename.split("/");
        return parts[parts.length - 1];
    }

    public Text getColumnQualifier() {
        return new Text(this.server + "/" + this.filename);
    }

    public Value getValue() {
        return new Value(this.filename.getBytes(StandardCharsets.UTF_8));
    }
}

