/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.map;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.map.MapFileUtil;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.MapFileIterator;
import org.apache.accumulo.core.iterators.system.SequenceFileIterator;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.hadoop.fs.Path;

public class MapFileOperations
extends FileOperations {
    @Override
    protected FileSKVIterator openReader(FileOperations.FileOptions options) throws IOException {
        RangeIterator iter = new RangeIterator(new MapFileIterator(options.getFileSystem(), options.getFilename(), options.getConfiguration()));
        if (options.isSeekToBeginning()) {
            iter.seek(new Range(new Key(), null), new ArrayList<ByteSequence>(), false);
        }
        return iter;
    }

    @Override
    protected FileSKVWriter openWriter(FileOperations.FileOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected FileSKVIterator openIndex(FileOperations.FileOptions options) throws IOException {
        return new SequenceFileIterator(MapFileUtil.openIndex(options.getConfiguration(), options.getFileSystem(), new Path(options.getFilename())), false);
    }

    @Override
    protected long getFileSize(FileOperations.FileOptions options) throws IOException {
        return options.getFileSystem().getFileStatus(new Path(options.getFilename() + "/" + "data")).getLen();
    }

    @Override
    protected FileSKVIterator openScanReader(FileOperations.FileOptions options) throws IOException {
        MapFileIterator mfIter = new MapFileIterator(options.getFileSystem(), options.getFilename(), options.getConfiguration());
        RangeIterator iter = new RangeIterator(mfIter);
        iter.seek(options.getRange(), options.getColumnFamilies(), options.isRangeInclusive());
        return iter;
    }

    public static class RangeIterator
    implements FileSKVIterator {
        SortedKeyValueIterator<Key, Value> reader;
        private Range range;
        private boolean hasTop;

        public RangeIterator(SortedKeyValueIterator<Key, Value> reader) {
            this.reader = reader;
        }

        @Override
        public void close() throws IOException {
            ((FileSKVIterator)this.reader).close();
        }

        @Override
        public Key getFirstKey() throws IOException {
            return ((FileSKVIterator)this.reader).getFirstKey();
        }

        @Override
        public Key getLastKey() throws IOException {
            return ((FileSKVIterator)this.reader).getLastKey();
        }

        @Override
        public DataInputStream getMetaStore(String name) throws IOException {
            return ((FileSKVIterator)this.reader).getMetaStore(name);
        }

        @Override
        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            return new RangeIterator(this.reader.deepCopy(env));
        }

        @Override
        public Key getTopKey() {
            if (!this.hasTop) {
                throw new IllegalStateException();
            }
            return this.reader.getTopKey();
        }

        @Override
        public Value getTopValue() {
            if (!this.hasTop) {
                throw new IllegalStateException();
            }
            return this.reader.getTopValue();
        }

        @Override
        public boolean hasTop() {
            return this.hasTop;
        }

        @Override
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void next() throws IOException {
            if (!this.hasTop) {
                throw new IllegalStateException();
            }
            this.reader.next();
            this.hasTop = this.reader.hasTop() && !this.range.afterEndKey(this.reader.getTopKey());
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            this.reader.seek(range, columnFamilies, inclusive);
            this.range = range;
            boolean bl = this.hasTop = this.reader.hasTop() && !range.afterEndKey(this.reader.getTopKey());
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }

        @Override
        public void closeDeepCopies() throws IOException {
            ((FileSKVIterator)this.reader).closeDeepCopies();
        }

        @Override
        public void setInterruptFlag(AtomicBoolean flag) {
            ((FileSKVIterator)this.reader).setInterruptFlag(flag);
        }

        @Override
        public FileSKVIterator getSample(SamplerConfigurationImpl sampleConfig) {
            return ((FileSKVIterator)this.reader).getSample(sampleConfig);
        }
    }
}

