/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.impl;

import com.google.common.cache.Cache;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.accumulo.core.file.blockfile.impl.SeekableByteArrayInputStream;
import org.apache.accumulo.core.file.rfile.bcfile.BCFile;
import org.apache.accumulo.core.file.rfile.bcfile.MetaBlockDoesNotExist;
import org.apache.accumulo.core.file.streams.RateLimitedInputStream;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.CacheEntry;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachableBlockFile {
    private static final Logger log = LoggerFactory.getLogger(CachableBlockFile.class);

    private CachableBlockFile() {
    }

    public static String pathToCacheId(Path p) {
        return p.toString();
    }

    public static class CachedBlockRead
    extends DataInputStream {
        private SeekableByteArrayInputStream seekableInput;
        private final CacheEntry cb;
        boolean indexable;

        public CachedBlockRead(InputStream in) {
            super(in);
            this.cb = null;
            this.seekableInput = null;
            this.indexable = false;
        }

        public CachedBlockRead(CacheEntry cb, byte[] buf) {
            this(new SeekableByteArrayInputStream(buf), cb);
        }

        private CachedBlockRead(SeekableByteArrayInputStream seekableInput, CacheEntry cb) {
            super(seekableInput);
            this.seekableInput = seekableInput;
            this.cb = cb;
            this.indexable = true;
        }

        public void seek(int position) {
            this.seekableInput.seek(position);
        }

        public int getPosition() {
            return this.seekableInput.getPosition();
        }

        public boolean isIndexable() {
            return this.indexable;
        }

        public byte[] getBuffer() {
            return this.seekableInput.getBuffer();
        }

        public <T extends CacheEntry.Weighable> T getIndex(Supplier<T> indexSupplier) {
            return this.cb.getIndex(indexSupplier);
        }

        public void indexWeightChanged() {
            this.cb.indexWeightChanged();
        }
    }

    public static class Reader
    implements Closeable {
        private final RateLimiter readLimiter;
        private final String cacheId;
        private final BlockCache _dCache;
        private final BlockCache _iCache;
        private Cache<String, Long> fileLenCache = null;
        private volatile InputStream fin = null;
        private boolean closed = false;
        private final Configuration conf;
        private final CryptoService cryptoService;
        private final IoeSupplier<InputStream> inputSupplier;
        private final IoeSupplier<Long> lengthSupplier;
        private final AtomicReference<BCFile.Reader> bcfr = new AtomicReference();
        private static final String ROOT_BLOCK_NAME = "!RootData";
        private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

        private long getCachedFileLen() throws IOException {
            try {
                return (Long)this.fileLenCache.get((Object)this.cacheId, this.lengthSupplier::get);
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to get " + this.cacheId + " len from cache ", e);
            }
        }

        private BCFile.Reader getBCFile(byte[] serializedMetadata) throws IOException {
            BCFile.Reader reader = this.bcfr.get();
            if (reader == null) {
                RateLimitedInputStream fsIn = new RateLimitedInputStream((InputStream)((Seekable)this.inputSupplier.get()), this.readLimiter);
                BCFile.Reader tmpReader = null;
                if (serializedMetadata == null) {
                    if (this.fileLenCache == null) {
                        tmpReader = new BCFile.Reader(fsIn, this.lengthSupplier.get(), this.conf, this.cryptoService);
                    } else {
                        long len = this.getCachedFileLen();
                        try {
                            tmpReader = new BCFile.Reader(fsIn, len, this.conf, this.cryptoService);
                        }
                        catch (Exception e) {
                            log.debug("Failed to open {}, clearing file length cache and retrying", (Object)this.cacheId, (Object)e);
                            this.fileLenCache.invalidate((Object)this.cacheId);
                        }
                        if (tmpReader == null) {
                            len = this.getCachedFileLen();
                            tmpReader = new BCFile.Reader(fsIn, len, this.conf, this.cryptoService);
                        }
                    }
                } else {
                    tmpReader = new BCFile.Reader(serializedMetadata, fsIn, this.conf, this.cryptoService);
                }
                if (!this.bcfr.compareAndSet(null, tmpReader)) {
                    fsIn.close();
                    tmpReader.close();
                    return this.bcfr.get();
                }
                this.fin = fsIn;
                return tmpReader;
            }
            return reader;
        }

        private BCFile.Reader getBCFile() throws IOException {
            CacheEntry mce;
            if (this._iCache != null && (mce = this._iCache.getBlock(this.cacheId + ROOT_BLOCK_NAME, new BCFileLoader())) != null) {
                return this.getBCFile(mce.getBuffer());
            }
            return this.getBCFile(null);
        }

        public Reader(CachableBuilder b) {
            this.cacheId = b.cacheId;
            this.inputSupplier = b.inputSupplier;
            this.lengthSupplier = b.lengthSupplier;
            this.fileLenCache = b.fileLenCache;
            this._dCache = b.dCache;
            this._iCache = b.iCache;
            this.readLimiter = b.readLimiter;
            this.conf = b.hadoopConf;
            this.cryptoService = Objects.requireNonNull(b.cryptoService);
        }

        public CachedBlockRead getMetaBlock(String blockName) throws IOException {
            if (this._iCache != null) {
                String _lookup = this.cacheId + "M" + blockName;
                try {
                    CacheEntry ce = this._iCache.getBlock(_lookup, new MetaBlockLoader(blockName));
                    if (ce != null) {
                        return new CachedBlockRead(ce, ce.getBuffer());
                    }
                }
                catch (UncheckedIOException uioe) {
                    if (uioe.getCause() instanceof MetaBlockDoesNotExist) {
                        throw new MetaBlockDoesNotExist(uioe);
                    }
                    throw uioe;
                }
            }
            BCFile.Reader.BlockReader _currBlock = this.getBCFile(null).getMetaBlock(blockName);
            return new CachedBlockRead(_currBlock);
        }

        public CachedBlockRead getMetaBlock(long offset, long compressedSize, long rawSize) throws IOException {
            String _lookup;
            CacheEntry ce;
            if (this._iCache != null && (ce = this._iCache.getBlock(_lookup = this.cacheId + "R" + offset, new RawBlockLoader(offset, compressedSize, rawSize, true))) != null) {
                return new CachedBlockRead(ce, ce.getBuffer());
            }
            BCFile.Reader.BlockReader _currBlock = this.getBCFile(null).getDataBlock(offset, compressedSize, rawSize);
            return new CachedBlockRead(_currBlock);
        }

        public CachedBlockRead getDataBlock(int blockIndex) throws IOException {
            String _lookup;
            CacheEntry ce;
            if (this._dCache != null && (ce = this._dCache.getBlock(_lookup = this.cacheId + "O" + blockIndex, new OffsetBlockLoader(blockIndex, false))) != null) {
                return new CachedBlockRead(ce, ce.getBuffer());
            }
            BCFile.Reader.BlockReader _currBlock = this.getBCFile().getDataBlock(blockIndex);
            return new CachedBlockRead(_currBlock);
        }

        public CachedBlockRead getDataBlock(long offset, long compressedSize, long rawSize) throws IOException {
            String _lookup;
            CacheEntry ce;
            if (this._dCache != null && (ce = this._dCache.getBlock(_lookup = this.cacheId + "R" + offset, new RawBlockLoader(offset, compressedSize, rawSize, false))) != null) {
                return new CachedBlockRead(ce, ce.getBuffer());
            }
            BCFile.Reader.BlockReader _currBlock = this.getBCFile().getDataBlock(offset, compressedSize, rawSize);
            return new CachedBlockRead(_currBlock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            BCFile.Reader reader = this.bcfr.get();
            if (reader != null) {
                reader.close();
            }
            if (this.fin != null) {
                InputStream inputStream = this.fin;
                synchronized (inputStream) {
                    this.fin.close();
                }
            }
        }

        private abstract class BaseBlockLoader
        implements BlockCache.Loader {
            private boolean loadingMetaBlock;

            abstract BCFile.Reader.BlockReader getBlockReader(int var1, BCFile.Reader var2) throws IOException;

            abstract String getBlockId();

            public BaseBlockLoader(boolean loadingMetaBlock) {
                this.loadingMetaBlock = loadingMetaBlock;
            }

            @Override
            public Map<String, BlockCache.Loader> getDependencies() {
                if (Reader.this.bcfr.get() == null && this.loadingMetaBlock) {
                    String _lookup = Reader.this.cacheId + Reader.ROOT_BLOCK_NAME;
                    return Collections.singletonMap(_lookup, new BCFileLoader());
                }
                return Collections.emptyMap();
            }

            @Override
            public byte[] load(int maxSize, Map<String, byte[]> dependencies) {
                try {
                    BCFile.Reader.BlockReader _currBlock;
                    BCFile.Reader reader = (BCFile.Reader)Reader.this.bcfr.get();
                    if (reader == null) {
                        if (this.loadingMetaBlock) {
                            byte[] serializedMetadata = dependencies.get(Reader.this.cacheId + Reader.ROOT_BLOCK_NAME);
                            reader = Reader.this.getBCFile(serializedMetadata);
                        } else {
                            reader = Reader.this.getBCFile();
                        }
                    }
                    if ((_currBlock = this.getBlockReader(maxSize, reader)) == null) {
                        return null;
                    }
                    byte[] b = null;
                    try {
                        b = new byte[(int)_currBlock.getRawSize()];
                        _currBlock.readFully(b);
                    }
                    catch (IOException e) {
                        log.debug("Error full blockRead for file " + Reader.this.cacheId + " for block " + this.getBlockId(), (Throwable)e);
                        throw new UncheckedIOException(e);
                    }
                    finally {
                        _currBlock.close();
                    }
                    return b;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        private class MetaBlockLoader
        extends BaseBlockLoader {
            String blockName;

            MetaBlockLoader(String blockName) {
                super(true);
                this.blockName = blockName;
            }

            @Override
            BCFile.Reader.BlockReader getBlockReader(int maxSize, BCFile.Reader bcfr) throws IOException {
                if (bcfr.getMetaBlockRawSize(this.blockName) > (long)Math.min(maxSize, 0x7FFFFFF7)) {
                    return null;
                }
                return bcfr.getMetaBlock(this.blockName);
            }

            @Override
            String getBlockId() {
                return "meta-" + this.blockName;
            }
        }

        private class OffsetBlockLoader
        extends BaseBlockLoader {
            private int blockIndex;

            private OffsetBlockLoader(int blockIndex, boolean loadingMeta) {
                super(loadingMeta);
                this.blockIndex = blockIndex;
            }

            @Override
            BCFile.Reader.BlockReader getBlockReader(int maxSize, BCFile.Reader bcfr) throws IOException {
                if (bcfr.getDataBlockRawSize(this.blockIndex) > (long)Math.min(maxSize, 0x7FFFFFF7)) {
                    return null;
                }
                return bcfr.getDataBlock(this.blockIndex);
            }

            @Override
            String getBlockId() {
                return "bi-" + this.blockIndex;
            }
        }

        private class RawBlockLoader
        extends BaseBlockLoader {
            private long offset;
            private long compressedSize;
            private long rawSize;

            private RawBlockLoader(long offset, long compressedSize, long rawSize, boolean loadingMeta) {
                super(loadingMeta);
                this.offset = offset;
                this.compressedSize = compressedSize;
                this.rawSize = rawSize;
            }

            @Override
            BCFile.Reader.BlockReader getBlockReader(int maxSize, BCFile.Reader bcfr) throws IOException {
                if (this.rawSize > (long)Math.min(maxSize, 0x7FFFFFF7)) {
                    return null;
                }
                return bcfr.getDataBlock(this.offset, this.compressedSize, this.rawSize);
            }

            @Override
            String getBlockId() {
                return "raw-(" + this.offset + "," + this.compressedSize + "," + this.rawSize + ")";
            }
        }

        private class BCFileLoader
        implements BlockCache.Loader {
            private BCFileLoader() {
            }

            @Override
            public Map<String, BlockCache.Loader> getDependencies() {
                return Collections.emptyMap();
            }

            @Override
            public byte[] load(int maxSize, Map<String, byte[]> dependencies) {
                try {
                    return Reader.this.getBCFile(null).serializeMetadata(maxSize);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    public static class CachableBuilder {
        String cacheId = null;
        IoeSupplier<InputStream> inputSupplier = null;
        IoeSupplier<Long> lengthSupplier = null;
        Cache<String, Long> fileLenCache = null;
        BlockCache dCache = null;
        BlockCache iCache = null;
        RateLimiter readLimiter = null;
        Configuration hadoopConf = null;
        CryptoService cryptoService = null;

        public CachableBuilder cacheId(String id) {
            this.cacheId = id;
            return this;
        }

        public CachableBuilder conf(Configuration hadoopConf) {
            this.hadoopConf = hadoopConf;
            return this;
        }

        public CachableBuilder fsPath(FileSystem fs, Path dataFile) {
            this.cacheId = CachableBlockFile.pathToCacheId(dataFile);
            this.inputSupplier = () -> fs.open(dataFile);
            this.lengthSupplier = () -> fs.getFileStatus(dataFile).getLen();
            return this;
        }

        public CachableBuilder input(InputStream is) {
            this.inputSupplier = () -> is;
            return this;
        }

        public CachableBuilder length(long len) {
            this.lengthSupplier = () -> len;
            return this;
        }

        public CachableBuilder fileLen(Cache<String, Long> cache) {
            this.fileLenCache = cache;
            return this;
        }

        public CachableBuilder data(BlockCache dCache) {
            this.dCache = dCache;
            return this;
        }

        public CachableBuilder index(BlockCache iCache) {
            this.iCache = iCache;
            return this;
        }

        public CachableBuilder readLimiter(RateLimiter readLimiter) {
            this.readLimiter = readLimiter;
            return this;
        }

        public CachableBuilder cryptoService(CryptoService cryptoService) {
            this.cryptoService = cryptoService;
            return this;
        }
    }

    private static interface IoeSupplier<T> {
        public T get() throws IOException;
    }
}

