/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.lru;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.accumulo.core.file.blockfile.cache.impl.ClassSize;
import org.apache.accumulo.core.file.blockfile.cache.lru.HeapSize;
import org.apache.accumulo.core.spi.cache.CacheEntry;

public class CachedBlock
implements HeapSize,
Comparable<CachedBlock> {
    public static final long PER_BLOCK_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 16 + ClassSize.STRING + ClassSize.BYTE_BUFFER + ClassSize.REFERENCE);
    private byte[] buffer;
    private final String blockName;
    private volatile long accessTime;
    private volatile long recordedSize;
    private BlockPriority priority;
    private CacheEntry.Weighable index;

    public CachedBlock(String blockName, byte[] buf, long accessTime, boolean inMemory) {
        this.buffer = buf;
        this.blockName = blockName;
        this.accessTime = accessTime;
        this.priority = inMemory ? BlockPriority.MEMORY : BlockPriority.SINGLE;
    }

    public void access(long accessTime) {
        this.accessTime = accessTime;
        if (this.priority == BlockPriority.SINGLE) {
            this.priority = BlockPriority.MULTI;
        }
    }

    @Override
    public long heapSize() {
        if (this.recordedSize < 0L) {
            throw new IllegalStateException("Block was evicted");
        }
        return this.recordedSize;
    }

    public int hashCode() {
        return Objects.hashCode(this.accessTime);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof CachedBlock && this.compareTo((CachedBlock)obj) == 0;
    }

    @Override
    public int compareTo(CachedBlock that) {
        if (this.accessTime == that.accessTime) {
            return 0;
        }
        return this.accessTime < that.accessTime ? 1 : -1;
    }

    public String getName() {
        return this.blockName;
    }

    public BlockPriority getPriority() {
        return this.priority;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public synchronized <T extends CacheEntry.Weighable> T getIndex(Supplier<T> supplier) {
        if (this.index == null && this.recordedSize >= 0L) {
            this.index = (CacheEntry.Weighable)supplier.get();
        }
        return (T)this.index;
    }

    private synchronized long _recordSize(AtomicLong totalSize) {
        long indexSize = this.index == null ? 0L : (long)this.index.weight();
        long newSize = (long)(ClassSize.align(this.blockName.length()) + ClassSize.align(this.buffer.length)) + PER_BLOCK_OVERHEAD + indexSize;
        long delta = newSize - this.recordedSize;
        this.recordedSize = newSize;
        return totalSize.addAndGet(delta);
    }

    synchronized long tryRecordSize(AtomicLong totalSize) {
        if (this.recordedSize >= 0L) {
            return this._recordSize(totalSize);
        }
        return -1L;
    }

    public synchronized long recordSize(AtomicLong totalSize) {
        if (this.recordedSize >= 0L) {
            return this._recordSize(totalSize);
        }
        throw new IllegalStateException("Block was evicted");
    }

    public synchronized long evicted(AtomicLong totalSize) {
        if (this.recordedSize >= 0L) {
            totalSize.addAndGet(this.recordedSize * -1L);
            long tmp = this.recordedSize;
            this.recordedSize = -1L;
            this.index = null;
            return tmp;
        }
        throw new IllegalStateException("already evicted");
    }

    public static enum BlockPriority {
        SINGLE,
        MULTI,
        MEMORY;

    }
}

