/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.cache.BlockCacheManager;
import org.apache.accumulo.core.spi.cache.CacheType;

public class BlockCacheConfiguration
implements BlockCacheManager.Configuration {
    private final long blockSize;
    private final Map<String, String> genProps;
    private final long indexMaxSize;
    private final long dataMaxSize;
    private final long summaryMaxSize;

    public BlockCacheConfiguration(AccumuloConfiguration conf) {
        this.genProps = conf.getAllPropertiesWithPrefix(Property.TSERV_PREFIX);
        this.indexMaxSize = conf.getAsBytes(Property.TSERV_INDEXCACHE_SIZE);
        this.dataMaxSize = conf.getAsBytes(Property.TSERV_DATACACHE_SIZE);
        this.summaryMaxSize = conf.getAsBytes(Property.TSERV_SUMMARYCACHE_SIZE);
        this.blockSize = conf.getAsBytes(Property.TSERV_DEFAULT_BLOCKSIZE);
    }

    @Override
    public long getMaxSize(CacheType type) {
        switch (type) {
            case INDEX: {
                return this.indexMaxSize;
            }
            case DATA: {
                return this.dataMaxSize;
            }
            case SUMMARY: {
                return this.summaryMaxSize;
            }
        }
        throw new IllegalArgumentException("Unknown block cache type");
    }

    @Override
    public long getBlockSize() {
        return this.blockSize;
    }

    public String toString() {
        return "indexMaxSize: " + this.indexMaxSize + "dataMaxSize: " + this.dataMaxSize + "summaryMaxSize: " + this.summaryMaxSize + ", blockSize: " + this.getBlockSize();
    }

    @Override
    public Map<String, String> getProperties(String prefix, CacheType type) {
        HashMap props = new HashMap();
        String defaultPrefix = BlockCacheManager.getFullyQualifiedPropertyPrefix(prefix);
        this.genProps.forEach((k, v) -> {
            if (k.startsWith(defaultPrefix)) {
                props.put(k.substring(defaultPrefix.length()), v);
            }
        });
        String typePrefix = BlockCacheManager.getFullyQualifiedPropertyPrefix(prefix, type);
        this.genProps.forEach((k, v) -> {
            if (k.startsWith(typePrefix)) {
                props.put(k.substring(typePrefix.length()), v);
            }
        });
        return Collections.unmodifiableMap(props);
    }
}

