/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.Collection;
import org.apache.accumulo.core.dataImpl.KeyExtent;

public enum TabletType {
    ROOT,
    METADATA,
    USER;


    public static TabletType type(KeyExtent ke) {
        if (ke.isRootTablet()) {
            return ROOT;
        }
        if (ke.isMeta()) {
            return METADATA;
        }
        return USER;
    }

    public static TabletType type(Collection<KeyExtent> extents) {
        if (extents.size() == 0) {
            throw new IllegalArgumentException();
        }
        TabletType ttype = null;
        for (KeyExtent extent : extents) {
            if (ttype == null) {
                ttype = TabletType.type(extent);
                continue;
            }
            if (ttype == TabletType.type(extent)) continue;
            throw new IllegalArgumentException("multiple extent types not allowed " + (Object)((Object)ttype) + " " + (Object)((Object)TabletType.type(extent)));
        }
        return ttype;
    }
}

