/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;

public class Credentials {
    private String principal;
    private AuthenticationToken token;

    public Credentials(String principal, AuthenticationToken token) {
        this.principal = principal;
        this.token = token;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public AuthenticationToken getToken() {
        return this.token;
    }

    public TCredentials toThrift(String instanceID) {
        TCredentials tCreds = new TCredentials(this.getPrincipal(), this.getToken().getClass().getName(), ByteBuffer.wrap(AuthenticationToken.AuthenticationTokenSerializer.serialize(this.getToken())), instanceID);
        if (this.getToken().isDestroyed()) {
            throw new RuntimeException("Token has been destroyed", new AccumuloSecurityException(this.getPrincipal(), SecurityErrorCode.TOKEN_EXPIRED));
        }
        return tCreds;
    }

    public static Credentials fromThrift(TCredentials serialized) {
        return new Credentials(serialized.getPrincipal(), AuthenticationToken.AuthenticationTokenSerializer.deserialize(serialized.getTokenClassName(), serialized.getToken()));
    }

    public final String serialize() {
        return (this.getPrincipal() == null ? "-" : Base64.getEncoder().encodeToString(this.getPrincipal().getBytes(StandardCharsets.UTF_8))) + ":" + (this.getToken() == null ? "-" : Base64.getEncoder().encodeToString(this.getToken().getClass().getName().getBytes(StandardCharsets.UTF_8))) + ":" + (this.getToken() == null ? "-" : Base64.getEncoder().encodeToString(AuthenticationToken.AuthenticationTokenSerializer.serialize(this.getToken())));
    }

    public static final Credentials deserialize(String serializedForm) {
        String[] split = serializedForm.split(":", 3);
        String principal = split[0].equals("-") ? null : new String(Base64.getDecoder().decode(split[0]), StandardCharsets.UTF_8);
        String tokenType = split[1].equals("-") ? null : new String(Base64.getDecoder().decode(split[1]), StandardCharsets.UTF_8);
        AuthenticationToken token = null;
        if (!split[2].equals("-")) {
            byte[] tokenBytes = Base64.getDecoder().decode(split[2]);
            token = AuthenticationToken.AuthenticationTokenSerializer.deserialize(tokenType, tokenBytes);
        }
        return new Credentials(principal, token);
    }

    public int hashCode() {
        return this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode();
    }

    public boolean equals(Object obj) {
        boolean pEq;
        if (obj == null || !(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)Credentials.class.cast(obj);
        boolean bl = this.getPrincipal() == null ? other.getPrincipal() == null : (pEq = this.getPrincipal().equals(other.getPrincipal()));
        if (!pEq) {
            return false;
        }
        return this.getToken() == null ? other.getToken() == null : this.getToken().equals(other.getToken());
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getPrincipal() + ":" + (this.getToken() == null ? null : this.getToken().getClass().getName()) + ":<hidden>";
    }
}

