/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.client.admin.ReplicationOperations;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.BatchWriterImpl;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.accumulo.core.clientImpl.ConditionalWriterImpl;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.InstanceOperationsImpl;
import org.apache.accumulo.core.clientImpl.MultiTableBatchWriterImpl;
import org.apache.accumulo.core.clientImpl.NamespaceOperationsImpl;
import org.apache.accumulo.core.clientImpl.ReplicationOperationsImpl;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.clientImpl.SecurityOperationsImpl;
import org.apache.accumulo.core.clientImpl.TableOperationsImpl;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.TabletServerBatchDeleter;
import org.apache.accumulo.core.clientImpl.TabletServerBatchReader;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.singletons.SingletonReservation;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientContext
implements AccumuloClient {
    private static final Logger log = LoggerFactory.getLogger(ClientContext.class);
    private ClientInfo info;
    private String instanceId;
    private final ZooCache zooCache;
    private Credentials creds;
    private BatchWriterConfig batchWriterConfig;
    private AccumuloConfiguration serverConf;
    private Configuration hadoopConf;
    private Supplier<Long> timeoutSupplier;
    private Supplier<SaslConnectionParams> saslSupplier;
    private Supplier<SslConnectionParams> sslSupplier;
    private TCredentials rpcCreds;
    private volatile boolean closed = false;
    private SecurityOperations secops = null;
    private TableOperationsImpl tableops = null;
    private NamespaceOperations namespaceops = null;
    private InstanceOperations instanceops = null;
    private ReplicationOperations replicationops = null;
    private SingletonReservation singletonReservation;

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("This client was closed.");
        }
    }

    private static <T> Supplier<T> memoizeWithExpiration(Supplier<T> s) {
        return () -> Suppliers.memoizeWithExpiration(((Supplier)s)::get, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS).get();
    }

    public ClientContext(Properties clientProperties) {
        this(ClientInfo.from(clientProperties));
    }

    public ClientContext(SingletonReservation reservation, ClientInfo info) {
        this(reservation, info, ClientConfConverter.toAccumuloConf(info.getProperties()));
    }

    public ClientContext(ClientInfo info) {
        this(info, ClientConfConverter.toAccumuloConf(info.getProperties()));
    }

    public ClientContext(ClientInfo info, AccumuloConfiguration serverConf) {
        this(SingletonReservation.noop(), info, serverConf);
    }

    public ClientContext(SingletonReservation reservation, ClientInfo info, AccumuloConfiguration serverConf) {
        this.info = info;
        this.hadoopConf = info.getHadoopConf();
        this.zooCache = new ZooCacheFactory().getZooCache(info.getZooKeepers(), info.getZooKeepersSessionTimeOut());
        this.serverConf = serverConf;
        this.timeoutSupplier = ClientContext.memoizeWithExpiration(() -> this.getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT));
        this.sslSupplier = ClientContext.memoizeWithExpiration(() -> SslConnectionParams.forClient(this.getConfiguration()));
        this.saslSupplier = ClientContext.memoizeWithExpiration(() -> SaslConnectionParams.from(this.getConfiguration(), this.getCredentials().getToken()));
        this.singletonReservation = Objects.requireNonNull(reservation);
        this.tableops = new TableOperationsImpl(this);
        this.namespaceops = new NamespaceOperationsImpl(this, this.tableops);
    }

    @Deprecated
    public Instance getDeprecatedInstance() {
        final ClientContext context = this;
        return new Instance(){

            @Override
            public String getRootTabletLocation() {
                return context.getRootTabletLocation();
            }

            @Override
            public List<String> getMasterLocations() {
                return context.getMasterLocations();
            }

            @Override
            public String getInstanceID() {
                return context.getInstanceID();
            }

            @Override
            public String getInstanceName() {
                return context.getInstanceName();
            }

            @Override
            public String getZooKeepers() {
                return context.getZooKeepers();
            }

            @Override
            public int getZooKeepersSessionTimeOut() {
                return context.getZooKeepersSessionTimeOut();
            }

            @Override
            public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
                return Connector.from(context);
            }
        };
    }

    public synchronized Credentials getCredentials() {
        this.ensureOpen();
        if (this.creds == null) {
            this.creds = new Credentials(this.info.getPrincipal(), this.info.getAuthenticationToken());
        }
        return this.creds;
    }

    public String getPrincipal() {
        this.ensureOpen();
        return this.getCredentials().getPrincipal();
    }

    public AuthenticationToken getAuthenticationToken() {
        this.ensureOpen();
        return this.getCredentials().getToken();
    }

    public Properties getProperties() {
        this.ensureOpen();
        return this.info.getProperties();
    }

    public synchronized void setCredentials(Credentials newCredentials) {
        Preconditions.checkArgument((newCredentials != null ? 1 : 0) != 0, (Object)"newCredentials is null");
        this.ensureOpen();
        this.creds = newCredentials;
        this.rpcCreds = null;
    }

    public AccumuloConfiguration getConfiguration() {
        this.ensureOpen();
        return this.serverConf;
    }

    public Configuration getHadoopConf() {
        this.ensureOpen();
        return this.hadoopConf;
    }

    public long getClientTimeoutInMillis() {
        this.ensureOpen();
        return this.timeoutSupplier.get();
    }

    public SslConnectionParams getClientSslParams() {
        this.ensureOpen();
        return this.sslSupplier.get();
    }

    public SaslConnectionParams getSaslParams() {
        this.ensureOpen();
        return this.saslSupplier.get();
    }

    public BatchWriterConfig getBatchWriterConfig() {
        this.ensureOpen();
        if (this.batchWriterConfig == null) {
            String durability;
            Long timeout;
            Long maxLatency;
            Properties props = this.info.getProperties();
            this.batchWriterConfig = new BatchWriterConfig();
            Long maxMemory = ClientProperty.BATCH_WRITER_MEMORY_MAX.getBytes(props);
            if (maxMemory != null) {
                this.batchWriterConfig.setMaxMemory(maxMemory);
            }
            if ((maxLatency = ClientProperty.BATCH_WRITER_LATENCY_MAX.getTimeInMillis(props)) != null) {
                this.batchWriterConfig.setMaxLatency(maxLatency, TimeUnit.SECONDS);
            }
            if ((timeout = ClientProperty.BATCH_WRITER_TIMEOUT_MAX.getTimeInMillis(props)) != null) {
                this.batchWriterConfig.setTimeout(timeout, TimeUnit.SECONDS);
            }
            if (!(durability = ClientProperty.BATCH_WRITER_DURABILITY.getValue(props)).isEmpty()) {
                this.batchWriterConfig.setDurability(Durability.valueOf(durability.toUpperCase()));
            }
        }
        return this.batchWriterConfig;
    }

    public synchronized TCredentials rpcCreds() {
        this.ensureOpen();
        if (this.getCredentials().getToken().isDestroyed()) {
            this.rpcCreds = null;
        }
        if (this.rpcCreds == null) {
            this.rpcCreds = this.getCredentials().toThrift(this.getInstanceID());
        }
        return this.rpcCreds;
    }

    public String getRootTabletLocation() {
        this.ensureOpen();
        String zRootLocPath = this.getZooKeeperRoot() + "/root_tablet/location";
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up root tablet location in zookeeper.", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        byte[] loc = this.zooCache.get(zRootLocPath);
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Found root tablet at {} in {}", new Object[]{Thread.currentThread().getId(), loc == null ? "null" : new String(loc, StandardCharsets.UTF_8), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        if (loc == null) {
            return null;
        }
        return new String(loc, StandardCharsets.UTF_8).split("\\|")[0];
    }

    public List<String> getMasterLocations() {
        this.ensureOpen();
        String masterLocPath = this.getZooKeeperRoot() + "/masters/lock";
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up master location in zookeeper.", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        byte[] loc = ZooUtil.getLockData(this.zooCache, masterLocPath);
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Found master at {} in {}", new Object[]{Thread.currentThread().getId(), loc == null ? "null" : new String(loc, StandardCharsets.UTF_8), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        if (loc == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new String(loc, StandardCharsets.UTF_8));
    }

    public String getInstanceID() {
        this.ensureOpen();
        String instanceName = this.info.getInstanceName();
        if (this.instanceId == null) {
            String instanceNamePath = "/accumulo/instances/" + instanceName;
            byte[] iidb = this.zooCache.get(instanceNamePath);
            if (iidb == null) {
                throw new RuntimeException("Instance name " + instanceName + " does not exist in zookeeper. Run \"accumulo org.apache.accumulo.server.util.ListInstances\" to see a list.");
            }
            this.instanceId = new String(iidb, StandardCharsets.UTF_8);
        }
        if (this.zooCache.get("/accumulo/" + this.instanceId) == null) {
            if (instanceName == null) {
                throw new RuntimeException("Instance id " + this.instanceId + " does not exist in zookeeper");
            }
            throw new RuntimeException("Instance id " + this.instanceId + " pointed to by the name " + instanceName + " does not exist in zookeeper");
        }
        return this.instanceId;
    }

    public String getZooKeeperRoot() {
        this.ensureOpen();
        return ZooUtil.getRoot(this.getInstanceID());
    }

    public String getInstanceName() {
        this.ensureOpen();
        return this.info.getInstanceName();
    }

    public String getZooKeepers() {
        this.ensureOpen();
        return this.info.getZooKeepers();
    }

    public int getZooKeepersSessionTimeOut() {
        this.ensureOpen();
        return this.info.getZooKeepersSessionTimeOut();
    }

    public ZooCache getZooCache() {
        this.ensureOpen();
        return this.zooCache;
    }

    TableId getTableId(String tableName) throws TableNotFoundException {
        TableId tableId = Tables.getTableId(this, tableName);
        if (Tables.getTableState(this, tableId) == TableState.OFFLINE) {
            throw new TableOfflineException(Tables.getTableOfflineMsg(this, tableId));
        }
        return tableId;
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.ensureOpen();
        return new TabletServerBatchReader(this, this.getTableId(tableName), authorizations, numQueryThreads);
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        Integer numQueryThreads = ClientProperty.BATCH_SCANNER_NUM_QUERY_THREADS.getInteger(this.getProperties());
        Objects.requireNonNull(numQueryThreads);
        this.ensureOpen();
        return this.createBatchScanner(tableName, authorizations, numQueryThreads);
    }

    @Override
    public BatchScanner createBatchScanner(String tableName) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        Authorizations auths = this.securityOperations().getUserAuthorizations(this.getPrincipal());
        return this.createBatchScanner(tableName, auths);
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, BatchWriterConfig config) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.ensureOpen();
        return new TabletServerBatchDeleter(this, this.getTableId(tableName), authorizations, numQueryThreads, config.merge(this.getBatchWriterConfig()));
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        this.ensureOpen();
        return this.createBatchDeleter(tableName, authorizations, numQueryThreads, new BatchWriterConfig());
    }

    @Override
    public BatchWriter createBatchWriter(String tableName, BatchWriterConfig config) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        this.ensureOpen();
        if (config == null) {
            config = new BatchWriterConfig();
        }
        return new BatchWriterImpl(this, this.getTableId(tableName), config.merge(this.getBatchWriterConfig()));
    }

    @Override
    public BatchWriter createBatchWriter(String tableName) throws TableNotFoundException {
        return this.createBatchWriter(tableName, new BatchWriterConfig());
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter(BatchWriterConfig config) {
        this.ensureOpen();
        return new MultiTableBatchWriterImpl(this, config.merge(this.getBatchWriterConfig()));
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter() {
        return this.createMultiTableBatchWriter(new BatchWriterConfig());
    }

    @Override
    public ConditionalWriter createConditionalWriter(String tableName, ConditionalWriterConfig config) throws TableNotFoundException {
        this.ensureOpen();
        return new ConditionalWriterImpl(this, this.getTableId(tableName), config);
    }

    @Override
    public Scanner createScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.ensureOpen();
        ScannerImpl scanner = new ScannerImpl(this, this.getTableId(tableName), authorizations);
        Integer batchSize = ClientProperty.SCANNER_BATCH_SIZE.getInteger(this.getProperties());
        if (batchSize != null) {
            scanner.setBatchSize(batchSize);
        }
        return scanner;
    }

    @Override
    public Scanner createScanner(String tableName) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        Authorizations auths = this.securityOperations().getUserAuthorizations(this.getPrincipal());
        return this.createScanner(tableName, auths);
    }

    @Override
    public String whoami() {
        this.ensureOpen();
        return this.getCredentials().getPrincipal();
    }

    @Override
    public synchronized TableOperations tableOperations() {
        this.ensureOpen();
        return this.tableops;
    }

    @Override
    public synchronized NamespaceOperations namespaceOperations() {
        this.ensureOpen();
        return this.namespaceops;
    }

    @Override
    public synchronized SecurityOperations securityOperations() {
        this.ensureOpen();
        if (this.secops == null) {
            this.secops = new SecurityOperationsImpl(this);
        }
        return this.secops;
    }

    @Override
    public synchronized InstanceOperations instanceOperations() {
        this.ensureOpen();
        if (this.instanceops == null) {
            this.instanceops = new InstanceOperationsImpl(this);
        }
        return this.instanceops;
    }

    @Override
    public synchronized ReplicationOperations replicationOperations() {
        this.ensureOpen();
        if (this.replicationops == null) {
            this.replicationops = new ReplicationOperationsImpl(this);
        }
        return this.replicationops;
    }

    @Override
    public Properties properties() {
        this.ensureOpen();
        Properties result = new Properties();
        this.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!key.equals(ClientProperty.AUTH_TOKEN.getKey())) {
                result.setProperty((String)key, (String)value);
            }
        }));
        return result;
    }

    public AuthenticationToken token() {
        this.ensureOpen();
        return this.getAuthenticationToken();
    }

    @Override
    public void close() {
        this.closed = true;
        this.singletonReservation.close();
    }

    public static class ClientBuilderImpl<T>
    implements AccumuloClient.InstanceArgs<T>,
    AccumuloClient.PropertyOptions<T>,
    AccumuloClient.AuthenticationArgs<T>,
    AccumuloClient.ConnectionOptions<T>,
    AccumuloClient.SslOptions<T>,
    AccumuloClient.SaslOptions<T>,
    AccumuloClient.ClientFactory<T>,
    AccumuloClient.FromOptions<T> {
        private Properties properties = new Properties();
        private AuthenticationToken token = null;
        private Function<ClientBuilderImpl<T>, T> builderFunction;

        public ClientBuilderImpl(Function<ClientBuilderImpl<T>, T> builderFunction) {
            this.builderFunction = builderFunction;
        }

        private ClientInfo getClientInfo() {
            if (this.token != null) {
                ClientProperty.validate(this.properties, false);
                return new ClientInfoImpl(this.properties, this.token);
            }
            ClientProperty.validate(this.properties);
            return new ClientInfoImpl(this.properties);
        }

        @Override
        public T build() {
            return this.builderFunction.apply(this);
        }

        public static AccumuloClient buildClient(ClientBuilderImpl<AccumuloClient> cbi) {
            SingletonReservation reservation = SingletonManager.getClientReservation();
            try {
                return new ClientContext(reservation, super.getClientInfo());
            }
            catch (RuntimeException e) {
                reservation.close();
                throw e;
            }
        }

        public static Properties buildProps(ClientBuilderImpl<Properties> cbi) {
            ClientProperty.validate(cbi.properties);
            return cbi.properties;
        }

        @Override
        public AccumuloClient.AuthenticationArgs<T> to(CharSequence instanceName, CharSequence zookeepers) {
            this.setProperty(ClientProperty.INSTANCE_NAME, instanceName);
            this.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS, zookeepers);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> truststore(CharSequence path) {
            this.setProperty(ClientProperty.SSL_TRUSTSTORE_PATH, path);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> truststore(CharSequence path, CharSequence password, CharSequence type) {
            this.setProperty(ClientProperty.SSL_TRUSTSTORE_PATH, path);
            this.setProperty(ClientProperty.SSL_TRUSTSTORE_PASSWORD, password);
            this.setProperty(ClientProperty.SSL_TRUSTSTORE_TYPE, type);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> keystore(CharSequence path) {
            this.setProperty(ClientProperty.SSL_KEYSTORE_PATH, path);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> keystore(CharSequence path, CharSequence password, CharSequence type) {
            this.setProperty(ClientProperty.SSL_KEYSTORE_PATH, path);
            this.setProperty(ClientProperty.SSL_KEYSTORE_PASSWORD, password);
            this.setProperty(ClientProperty.SSL_KEYSTORE_TYPE, type);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> useJsse() {
            this.setProperty(ClientProperty.SSL_USE_JSSE, "true");
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> zkTimeout(int timeout) {
            ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.setTimeInMillis(this.properties, Long.valueOf(timeout));
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> useSsl() {
            this.setProperty(ClientProperty.SSL_ENABLED, "true");
            return this;
        }

        @Override
        public AccumuloClient.SaslOptions<T> useSasl() {
            this.setProperty(ClientProperty.SASL_ENABLED, "true");
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> batchWriterConfig(BatchWriterConfig batchWriterConfig) {
            ClientProperty.BATCH_WRITER_MEMORY_MAX.setBytes(this.properties, batchWriterConfig.getMaxMemory());
            ClientProperty.BATCH_WRITER_LATENCY_MAX.setTimeInMillis(this.properties, batchWriterConfig.getMaxLatency(TimeUnit.MILLISECONDS));
            ClientProperty.BATCH_WRITER_TIMEOUT_MAX.setTimeInMillis(this.properties, batchWriterConfig.getTimeout(TimeUnit.MILLISECONDS));
            this.setProperty(ClientProperty.BATCH_WRITER_THREADS_MAX, batchWriterConfig.getMaxWriteThreads());
            this.setProperty(ClientProperty.BATCH_WRITER_DURABILITY, batchWriterConfig.getDurability().toString());
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> batchScannerQueryThreads(int numQueryThreads) {
            this.setProperty(ClientProperty.BATCH_SCANNER_NUM_QUERY_THREADS, numQueryThreads);
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> scannerBatchSize(int batchSize) {
            this.setProperty(ClientProperty.SCANNER_BATCH_SIZE, batchSize);
            return this;
        }

        @Override
        public AccumuloClient.SaslOptions<T> primary(CharSequence kerberosServerPrimary) {
            this.setProperty(ClientProperty.SASL_KERBEROS_SERVER_PRIMARY, kerberosServerPrimary);
            return this;
        }

        @Override
        public AccumuloClient.SaslOptions<T> qop(CharSequence qualityOfProtection) {
            this.setProperty(ClientProperty.SASL_QOP, qualityOfProtection);
            return this;
        }

        @Override
        public AccumuloClient.FromOptions<T> from(String propertiesFilePath) {
            return this.from(ClientInfoImpl.toProperties(propertiesFilePath));
        }

        @Override
        public AccumuloClient.FromOptions<T> from(Path propertiesFile) {
            return this.from(ClientInfoImpl.toProperties(propertiesFile));
        }

        @Override
        public AccumuloClient.FromOptions<T> from(Properties properties) {
            this.properties = new Properties();
            this.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> as(CharSequence username, CharSequence password) {
            this.setProperty(ClientProperty.AUTH_PRINCIPAL, username);
            ClientProperty.setPassword(this.properties, password);
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> as(CharSequence principal, Path keyTabFile) {
            this.setProperty(ClientProperty.AUTH_PRINCIPAL, principal);
            ClientProperty.setKerberosKeytab(this.properties, keyTabFile.toString());
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> as(CharSequence principal, AuthenticationToken token) {
            if (token.isDestroyed()) {
                throw new IllegalArgumentException("AuthenticationToken has been destroyed");
            }
            this.setProperty(ClientProperty.AUTH_PRINCIPAL, principal.toString());
            ClientProperty.setAuthenticationToken(this.properties, token);
            this.token = token;
            return this;
        }

        public void setProperty(ClientProperty property, CharSequence value) {
            this.properties.setProperty(property.getKey(), value.toString());
        }

        public void setProperty(ClientProperty property, Long value) {
            this.setProperty(property, Long.toString(value));
        }

        public void setProperty(ClientProperty property, Integer value) {
            this.setProperty(property, Integer.toString(value));
        }
    }
}

