/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.summary;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.summary.SummarizerConfigurationUtil;

public class SummarizerConfiguration {
    private final String className;
    private final Map<String, String> options;
    private int hashCode = 0;
    private final String configId;

    private SummarizerConfiguration(String className, String configId, Map<String, String> options) {
        this.className = className;
        this.options = ImmutableMap.copyOf(options);
        if (configId == null) {
            ArrayList<String> keys = new ArrayList<String>(this.options.keySet());
            Collections.sort(keys);
            Hasher hasher = Hashing.murmur3_32().newHasher();
            hasher.putString((CharSequence)className, StandardCharsets.UTF_8);
            for (String key : keys) {
                hasher.putString((CharSequence)key, StandardCharsets.UTF_8);
                hasher.putString((CharSequence)options.get(key), StandardCharsets.UTF_8);
            }
            this.configId = hasher.hash().toString();
        } else {
            this.configId = configId;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getPropertyId() {
        return this.configId;
    }

    public String toString() {
        return this.className + " " + this.configId + " " + this.options;
    }

    public boolean equals(Object o) {
        if (o instanceof SummarizerConfiguration) {
            SummarizerConfiguration osc = (SummarizerConfiguration)o;
            return this.className.equals(osc.className) && this.options.equals(osc.options);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 31 * this.options.hashCode() + this.className.hashCode();
        }
        return this.hashCode;
    }

    public Map<String, String> toTableProperties() {
        return SummarizerConfigurationUtil.toTablePropertiesMap(Collections.singletonList(this));
    }

    public static Map<String, String> toTableProperties(SummarizerConfiguration ... configurations) {
        return SummarizerConfigurationUtil.toTablePropertiesMap(Arrays.asList(configurations));
    }

    public static Map<String, String> toTableProperties(Collection<SummarizerConfiguration> configurations) {
        return SummarizerConfigurationUtil.toTablePropertiesMap(new ArrayList<SummarizerConfiguration>(configurations));
    }

    public static Collection<SummarizerConfiguration> fromTableProperties(Map<String, String> props) {
        return SummarizerConfiguration.fromTableProperties(props.entrySet());
    }

    public static Collection<SummarizerConfiguration> fromTableProperties(Iterable<Map.Entry<String, String>> props) {
        return SummarizerConfigurationUtil.getSummarizerConfigs(props);
    }

    public static Builder builder(String className) {
        return new Builder(className);
    }

    public static Builder builder(Class<? extends Summarizer> clazz) {
        return new Builder(clazz.getName());
    }

    public static class Builder {
        private String className;
        private ImmutableMap.Builder<String, String> imBuilder;
        private String configId = null;

        private Builder(String className) {
            this.className = className;
            this.imBuilder = ImmutableMap.builder();
        }

        public Builder setPropertyId(String propId) {
            Preconditions.checkArgument((boolean)propId.matches("\\w+"), (String)"Config Id %s is not alphanum", (Object)propId);
            this.configId = propId;
            return this;
        }

        public Builder addOption(String key, String value) {
            Preconditions.checkArgument((boolean)key.matches("\\w+"), (String)"Option Id %s is not alphanum", (Object)key);
            this.imBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addOption(String key, long value) {
            return this.addOption(key, Long.toString(value));
        }

        public Builder addOptions(String ... keyValuePairs) {
            Preconditions.checkArgument((keyValuePairs.length % 2 == 0 && keyValuePairs.length > 0 ? 1 : 0) != 0, (String)"Require an even, positive number of arguments, got %s", (int)keyValuePairs.length);
            for (int i = 1; i < keyValuePairs.length; i += 2) {
                this.addOption(keyValuePairs[i - 1], keyValuePairs[i]);
            }
            return this;
        }

        public Builder addOptions(Map<String, String> options) {
            options.entrySet().forEach(e -> this.addOption((String)e.getKey(), (String)e.getValue()));
            return this;
        }

        public SummarizerConfiguration build() {
            return new SummarizerConfiguration(this.className, this.configId, (Map)this.imBuilder.build());
        }
    }
}

