/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.summary;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.summary.CountingSummarizer;
import org.apache.accumulo.core.client.summary.Summary;

public class CounterSummary {
    private Map<String, Long> stats;

    public CounterSummary(Summary summary) {
        this(summary, true);
    }

    public CounterSummary(Summary summary, boolean checkType) {
        if (checkType) {
            String className = summary.getSummarizerConfiguration().getClassName();
            try {
                this.getClass().getClassLoader().loadClass(className).asSubclass(CountingSummarizer.class);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(className + " is not an instance of " + CountingSummarizer.class.getSimpleName(), e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to check summary was produced by a " + CountingSummarizer.class.getSimpleName(), e);
            }
        }
        this.stats = summary.getStatistics();
    }

    @VisibleForTesting
    CounterSummary(Map<String, Long> stats) {
        this.stats = stats;
    }

    public long getSeen() {
        return this.stats.getOrDefault("seen", 0L);
    }

    public long getEmitted() {
        return this.stats.getOrDefault("emitted", 0L);
    }

    public long getIgnored() {
        return this.getTooLong() + this.getTooMany();
    }

    public long getTooLong() {
        return this.stats.getOrDefault("tooLong", 0L);
    }

    public long getTooMany() {
        return this.stats.getOrDefault("tooMany", 0L);
    }

    public long getDeletesIgnored() {
        return this.stats.getOrDefault("deletesIgnored", 0L);
    }

    public Map<String, Long> getCounters() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : this.stats.entrySet()) {
            if (!entry.getKey().startsWith("c:")) continue;
            ret.put(entry.getKey().substring("c:".length()), entry.getValue());
        }
        return ret;
    }
}

