/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.sample;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.sample.Sampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.sample.impl.DataoutputHasher;

public abstract class AbstractHashSampler
implements Sampler {
    private HashFunction hashFunction;
    private int modulus;
    private static final Set<String> VALID_OPTIONS = ImmutableSet.of((Object)"hasher", (Object)"modulus");

    protected boolean isValidOption(String option) {
        return VALID_OPTIONS.contains(option);
    }

    @Override
    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="these hashes don't protect any secrets, just used for binning")
    public void init(SamplerConfiguration config) {
        String hasherOpt = config.getOptions().get("hasher");
        String modulusOpt = config.getOptions().get("modulus");
        Objects.requireNonNull(hasherOpt, "Hasher not specified");
        Objects.requireNonNull(modulusOpt, "Modulus not specified");
        for (String option : config.getOptions().keySet()) {
            Preconditions.checkArgument((boolean)this.isValidOption(option), (String)"Unknown option : %s", (Object)option);
        }
        switch (hasherOpt) {
            case "murmur3_32": {
                this.hashFunction = Hashing.murmur3_32();
                break;
            }
            case "md5": {
                HashFunction deprecatedMd5;
                this.hashFunction = deprecatedMd5 = Hashing.md5();
                break;
            }
            case "sha1": {
                HashFunction deprecatedSha1;
                this.hashFunction = deprecatedSha1 = Hashing.sha1();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hasher " + hasherOpt);
            }
        }
        this.modulus = Integer.parseInt(modulusOpt);
    }

    protected abstract void hash(DataOutput var1, Key var2) throws IOException;

    @Override
    public boolean accept(Key k) {
        Hasher hasher = this.hashFunction.newHasher();
        try {
            this.hash(new DataoutputHasher(hasher), k);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hasher.hash().asInt() % this.modulus == 0;
    }
}

