/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.Lexicoder;
import org.apache.accumulo.core.clientImpl.lexicoder.AbstractLexicoder;
import org.apache.accumulo.core.clientImpl.lexicoder.ByteUtils;
import org.apache.accumulo.core.util.ComparablePair;

public class PairLexicoder<A extends Comparable<A>, B extends Comparable<B>>
extends AbstractLexicoder<ComparablePair<A, B>> {
    private Lexicoder<A> firstLexicoder;
    private Lexicoder<B> secondLexicoder;

    public PairLexicoder(Lexicoder<A> firstLexicoder, Lexicoder<B> secondLexicoder) {
        this.firstLexicoder = firstLexicoder;
        this.secondLexicoder = secondLexicoder;
    }

    @Override
    public byte[] encode(ComparablePair<A, B> data) {
        return ByteUtils.concat(ByteUtils.escape(this.firstLexicoder.encode((Comparable)data.getFirst())), ByteUtils.escape(this.secondLexicoder.encode((Comparable)data.getSecond())));
    }

    @Override
    public ComparablePair<A, B> decode(byte[] b) {
        return (ComparablePair)super.decode(b);
    }

    @Override
    protected ComparablePair<A, B> decodeUnchecked(byte[] data, int offset, int len) {
        byte[][] fields = ByteUtils.split(data, offset, len);
        if (fields.length != 2) {
            throw new RuntimeException("Data does not have 2 fields, it has " + fields.length);
        }
        return new ComparablePair<Comparable, Comparable>((Comparable)this.firstLexicoder.decode(ByteUtils.unescape(fields[0])), (Comparable)this.secondLexicoder.decode(ByteUtils.unescape(fields[1])));
    }
}

